/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.addons.node;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.BiFunction;
import kasuga.lib.core.addons.node.PackageScanner;
import kasuga.lib.core.addons.resource.ResourceProvider;
import kasuga.lib.core.javascript.JavascriptContext;
import kasuga.lib.core.javascript.engine.annotations.HostAccess;

public class AssetReader
implements BiFunction<String, String, String> {
    public static HashMap<String, BiFunction<InputStream, UUID, Object>> assetReaders = new HashMap();
    private final HashMap<UUID, Object> assets;
    private final JavascriptContext context;
    private final String dirname;
    private final String assetRoot;
    ResourceProvider provider;

    public AssetReader(String dirname, JavascriptContext context, ResourceProvider provider, HashMap<UUID, Object> assets, String assetRoot) {
        this.provider = provider;
        this.context = context;
        this.assets = assets;
        this.dirname = dirname;
        this.assetRoot = assetRoot == null ? "/" : assetRoot;
    }

    @Override
    @HostAccess.Export
    public String apply(String path, String resourceType) {
        UUID uuid;
        if (!assetReaders.containsKey(resourceType)) {
            return null;
        }
        BiFunction<InputStream, UUID, Object> reader = assetReaders.get(resourceType);
        if (!path.startsWith("/")) {
            path = PackageScanner.joinPath(PackageScanner.resolve(PackageScanner.splitPath(this.dirname), PackageScanner.splitPath(path)));
        }
        if (this.assetRoot != null && !this.assetRoot.equals("")) {
            path = PackageScanner.joinPath(PackageScanner.resolve(PackageScanner.splitPath(this.assetRoot), PackageScanner.splitPath(path)));
        }
        while (this.assets.containsKey(uuid = UUID.randomUUID())) {
        }
        UUID finalUuid = uuid;
        try (InputStream stream = this.provider.open(path);){
            this.assets.put(finalUuid, reader.apply(stream, finalUuid));
            this.context.collectEffect(() -> this.assets.remove(finalUuid));
        }
        catch (IOException e) {
            return null;
        }
        return finalUuid.toString();
    }
}

