/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.addons.node;

import com.google.common.base.Splitter;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.addons.node.NodePackage;
import kasuga.lib.core.addons.node.PackageReader;
import kasuga.lib.core.addons.resource.FlatFilesystem;
import kasuga.lib.core.addons.resource.HierarchicalFilesystem;
import kasuga.lib.core.addons.resource.ResourceProvider;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.core.util.glob.GlobMatcher;

public class PackageScanner {
    public static Splitter PATH_SPLITTER = Splitter.on((Pattern)Pattern.compile("[\\\\/]")).omitEmptyStrings().trimResults();

    public static Pair<NodePackage, List<NodePackage>> scan(ResourceProvider provider) {
        if (!provider.exists("/package.json")) {
            return null;
        }
        ArrayList<NodePackage> result = new ArrayList<NodePackage>();
        NodePackage rootPackage = null;
        try {
            InputStream stream = provider.open("/package.json");
            InputStreamReader reader = new InputStreamReader(stream);
            JsonObject sourceObject = (JsonObject)KasugaLib.GSON.fromJson((Reader)reader, JsonObject.class);
            rootPackage = NodePackage.parse(sourceObject, new PackageReader("/", provider));
            if (rootPackage.workspaces != null) {
                ArrayList<List<String>> workspaces = new ArrayList<List<String>>();
                for (String workspace : rootPackage.workspaces) {
                    ArrayList<String> workspacePath = new ArrayList<String>(PackageScanner.splitPath(workspace));
                    workspacePath.add("package.json");
                    workspaces.add(workspacePath);
                }
                GlobMatcher matcher = new GlobMatcher(workspaces);
                result.addAll(PackageScanner.match(matcher, provider));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (rootPackage == null) {
            return null;
        }
        return Pair.of(rootPackage, result);
    }

    private static List<NodePackage> match(GlobMatcher matcher, ResourceProvider provider) {
        if (provider instanceof HierarchicalFilesystem) {
            HierarchicalFilesystem hierarchical = (HierarchicalFilesystem)provider;
            return PackageScanner.matchHierarchical(matcher, hierarchical);
        }
        if (provider instanceof FlatFilesystem) {
            FlatFilesystem flat = (FlatFilesystem)provider;
            return PackageScanner.matchFlat(matcher, flat);
        }
        throw new IllegalArgumentException("Unsupported provider type");
    }

    private static List<NodePackage> matchHierarchical(GlobMatcher matcher, HierarchicalFilesystem hierarchical) {
        List<List<String>> workspaces = matcher.match(pPath -> {
            try {
                return hierarchical.list(PackageScanner.joinPath(pPath));
            }
            catch (IOException e) {
                return List.of();
            }
        }, scan -> true);
        return PackageScanner.collect(hierarchical, workspaces);
    }

    public static List<NodePackage> matchFlat(GlobMatcher matcher, FlatFilesystem flat) {
        List<List<String>> workspaces = matcher.collect(flat.listEntries().map(PackageScanner::splitPath).filter(t -> t.size() > 0));
        return PackageScanner.collect(flat, workspaces);
    }

    public static List<NodePackage> collect(ResourceProvider provider, List<List<String>> workspaces) {
        ArrayList<NodePackage> result = new ArrayList<NodePackage>();
        for (List<String> workspace : workspaces) {
            String path = PackageScanner.joinPath(workspace.subList(0, workspace.size() - 1));
            try {
                InputStream stream = provider.open(path + "/package.json");
                InputStreamReader reader = new InputStreamReader(stream);
                JsonObject sourceObject = (JsonObject)KasugaLib.GSON.fromJson((Reader)reader, JsonObject.class);
                NodePackage nodePackage = NodePackage.parse(sourceObject, new PackageReader(path, provider));
                result.add(nodePackage);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static List<String> splitPath(String path) {
        return PATH_SPLITTER.splitToList((CharSequence)path);
    }

    public static String joinPath(Collection<String> path) {
        return String.join((CharSequence)"/", path);
    }

    @SafeVarargs
    public static List<String> resolve(List<String> ... paths) {
        ArrayList<String> result = new ArrayList<String>();
        for (List<String> path : paths) {
            for (String pathItem : path) {
                if (Objects.equals(pathItem, ".")) continue;
                if (Objects.equals(pathItem, "..") && !result.isEmpty()) {
                    result.remove(result.size() - 1);
                    continue;
                }
                result.add(pathItem);
            }
        }
        return result;
    }
}

