/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.addons.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import kasuga.lib.core.addons.resource.HierarchicalFilesystem;
import kasuga.lib.core.addons.resource.ResourceProvider;
import kasuga.lib.mixins.mixin.resources.PathPackResourceMixin;
import net.minecraftforge.resource.PathPackResources;

public class VanillaPathResourcePackProvider
implements ResourceProvider,
HierarchicalFilesystem {
    private final Path source;
    private final PathPackResources pack;

    public VanillaPathResourcePackProvider(Path source, PathPackResources pack) {
        this.source = source;
        this.pack = pack;
    }

    @Override
    public InputStream open(String path) throws IOException {
        Path filePath = this.resolve(path);
        System.out.printf("Opening file: %s\n", filePath.toString());
        return Files.newInputStream(filePath, new OpenOption[0]);
    }

    @Override
    public boolean exists(String path) {
        Path filePath = this.resolve(path);
        System.out.printf("Testing file: %s\n", filePath.toString());
        return Files.exists(filePath, new LinkOption[0]);
    }

    @Override
    public List<String> list(String path) throws IOException {
        try (Stream<Path> stream = Files.list(this.resolve(path));){
            List<String> list = stream.map(p -> p.getFileName().toString()).toList();
            return list;
        }
    }

    @Override
    public boolean isRegularFile(String path) {
        return Files.isRegularFile(this.resolve(path), new LinkOption[0]);
    }

    @Override
    public boolean isDirectory(String path) {
        return Files.isDirectory(this.resolve(path), new LinkOption[0]);
    }

    public Path resolve(String path) {
        if (((String)path).startsWith("/")) {
            path = ((String)path).substring(1);
        }
        path = "script/" + (String)path;
        return ((PathPackResourceMixin)this.pack).invokeResolve(new String[]{path});
    }
}

