/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.base;

import java.util.Optional;
import java.util.function.Supplier;
import kasuga.lib.core.util.LazyRecomputable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.jetbrains.annotations.Nullable;

public class BucketItem
extends net.minecraft.world.item.BucketItem {
    private final LazyRecomputable<Fluid> fluidSupplier = LazyRecomputable.of(supplier::get);

    public BucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        BlockHitResult blockhitresult;
        Fluid content = this.fluidSupplier.get();
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)pPlayer, (Level)pLevel, (ItemStack)itemstack, (HitResult)(blockhitresult = BucketItem.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)(content == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE))));
        if (ret != null) {
            return ret;
        }
        if (blockhitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.m_82425_();
        Direction direction = blockhitresult.m_82434_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        if (pLevel.m_7966_(pPlayer, blockpos) && pPlayer.m_36204_(blockpos1, direction, itemstack)) {
            BlockPos blockpos2;
            if (content == Fluids.f_76191_) {
                BucketPickup bucketpickup;
                ItemStack itemstack1;
                BlockState blockstate1 = pLevel.m_8055_(blockpos);
                if (blockstate1.m_60734_() instanceof BucketPickup && !(itemstack1 = (bucketpickup = (BucketPickup)blockstate1.m_60734_()).m_142598_((LevelAccessor)pLevel, blockpos, blockstate1)).m_41619_()) {
                    pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    bucketpickup.getPickupSound(blockstate1).ifPresent(p_150709_ -> pPlayer.m_5496_(p_150709_, 1.0f, 1.0f));
                    pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157816_, blockpos);
                    ItemStack itemstack2 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)pPlayer, (ItemStack)itemstack1);
                    if (!pLevel.f_46443_) {
                        CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)pPlayer, itemstack1);
                    }
                    return InteractionResultHolder.m_19092_((Object)itemstack2, (boolean)pLevel.m_5776_());
                }
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            BlockState blockstate1 = pLevel.m_8055_(blockpos);
            BlockPos blockPos = blockpos2 = this.canBlockContainFluid(pLevel, blockpos, blockstate1) ? blockpos : blockpos1;
            if (this.emptyContents(pPlayer, pLevel, blockpos2, blockhitresult, itemstack)) {
                this.m_142131_(pPlayer, pLevel, itemstack, blockpos2);
                if (pPlayer instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)pPlayer, blockpos2, itemstack);
                }
                pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)BucketItem.m_40699_((ItemStack)itemstack, (Player)pPlayer), (boolean)pLevel.m_5776_());
            }
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public boolean emptyContents(@javax.annotation.Nullable Player p_150716_, Level p_150717_, BlockPos p_150718_, @javax.annotation.Nullable BlockHitResult p_150719_, @javax.annotation.Nullable ItemStack container) {
        Fluid content = this.fluidSupplier.get();
        if (!(content instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockstate = p_150717_.m_8055_(p_150718_);
        Block block = blockstate.m_60734_();
        Material material = blockstate.m_60767_();
        boolean flag = blockstate.m_60722_(content);
        boolean flag1 = blockstate.m_60795_() || flag || block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)p_150717_, p_150718_, blockstate, content);
        Optional containedFluidStack = Optional.ofNullable(container).flatMap(FluidUtil::getFluidContained);
        if (!flag1) {
            return p_150719_ != null && this.emptyContents(p_150716_, p_150717_, p_150719_.m_82425_().m_121945_(p_150719_.m_82434_()), null, container);
        }
        if (containedFluidStack.isPresent() && content.getFluidType().isVaporizedOnPlacement(p_150717_, p_150718_, (FluidStack)containedFluidStack.get())) {
            content.getFluidType().onVaporize(p_150716_, p_150717_, p_150718_, (FluidStack)containedFluidStack.get());
            return true;
        }
        if (p_150717_.m_6042_().f_63857_() && content.m_205067_(FluidTags.f_13131_)) {
            int i = p_150718_.m_123341_();
            int j = p_150718_.m_123342_();
            int k = p_150718_.m_123343_();
            p_150717_.m_5594_(p_150716_, p_150718_, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (p_150717_.f_46441_.m_188501_() - p_150717_.f_46441_.m_188501_()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                p_150717_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)p_150717_, p_150718_, blockstate, content)) {
            ((LiquidBlockContainer)block).m_7361_((LevelAccessor)p_150717_, p_150718_, blockstate, ((FlowingFluid)content).m_76068_(false));
            this.m_7718_(p_150716_, (LevelAccessor)p_150717_, p_150718_);
            return true;
        }
        if (!p_150717_.f_46443_ && flag && !material.m_76332_()) {
            p_150717_.m_46961_(p_150718_, true);
        }
        if (!p_150717_.m_7731_(p_150718_, content.m_76145_().m_76188_(), 11) && !blockstate.m_60819_().m_76170_()) {
            return false;
        }
        this.m_7718_(p_150716_, (LevelAccessor)p_150717_, p_150718_);
        return true;
    }

    protected void m_7718_(@javax.annotation.Nullable Player pPlayer, LevelAccessor pLevel, BlockPos pPos) {
        Fluid content = this.fluidSupplier.get();
        SoundEvent soundevent = content.getFluidType().getSound(pPlayer, (BlockGetter)pLevel, pPos, SoundActions.BUCKET_EMPTY);
        if (soundevent == null) {
            soundevent = content.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        }
        pLevel.m_5594_(pPlayer, pPos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157769_, pPos);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (((Object)((Object)this)).getClass() == BucketItem.class) {
            return new FluidBucketWrapper(stack);
        }
        return super.initCapabilities(stack, nbt);
    }

    protected boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, posIn, blockstate, this.fluidSupplier.get());
    }
}

