/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.base.item_helper;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import kasuga.lib.core.base.item_helper.ExternalProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class ExternalRemainderBlockItem
extends BlockItem {
    @Nonnull
    private final Supplier<Item> craftingRemainder;

    public ExternalRemainderBlockItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
        if (pProperties instanceof ExternalProperties) {
            ExternalProperties externalProperties = (ExternalProperties)pProperties;
            this.craftingRemainder = externalProperties.craftingRemainderItem;
        } else {
            this.craftingRemainder = () -> null;
        }
    }

    @Nonnull
    public Supplier<Item> getCraftingRemainder() {
        return this.craftingRemainder;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return super.hasCraftingRemainingItem(stack) || this.craftingRemainder.get() != null;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        ItemStack remain = super.getCraftingRemainingItem(itemStack);
        if ((remain == ItemStack.f_41583_ || remain.m_150930_(Items.f_41852_)) && this.craftingRemainder.get() != null) {
            remain = this.craftingRemainder.get().m_7968_();
        }
        return remain;
    }
}

