/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.channel;

import java.util.HashMap;
import kasuga.lib.core.channel.address.LabelTypeRegistry;
import kasuga.lib.core.channel.network.NetworkManager;
import kasuga.lib.core.channel.network.NetworkServerManager;
import kasuga.lib.core.channel.packets.ChannelNetworkPacket;
import kasuga.lib.core.channel.route.SimpleRouter;
import net.minecraft.server.level.ServerPlayer;

public class ChannelNetworkManager {
    public LabelTypeRegistry labelTypeRegistry = new LabelTypeRegistry();
    public ChannelNetworkPacket packet = new ChannelNetworkPacket();
    public SimpleRouter SERVER_ROUTER = new SimpleRouter();
    public HashMap<ServerPlayer, NetworkServerManager> SERVER = new HashMap();
    public SimpleRouter CLIENT_ROUTER = new SimpleRouter();
    public NetworkManager CLIENT = new NetworkManager(this.CLIENT_ROUTER);
    private boolean clientConnectionExisted = false;

    public NetworkManager server(ServerPlayer player) {
        return this.SERVER.computeIfAbsent(player, k -> new NetworkServerManager(this.SERVER_ROUTER, player));
    }

    public void closeServer(ServerPlayer player) {
        NetworkServerManager manager = this.SERVER.remove(player);
        if (manager != null) {
            manager.close();
        }
    }

    public void closeClient() {
        this.CLIENT.close();
    }

    public void reloadClient() {
        this.closeClient();
        this.CLIENT = new NetworkManager(this.CLIENT_ROUTER);
    }

    public NetworkManager client() {
        return this.CLIENT;
    }

    public void disableClient() {
        this.clientConnectionExisted = false;
    }

    public void enableClient() {
        this.clientConnectionExisted = true;
    }

    public boolean clientIsEnabled() {
        return this.clientConnectionExisted;
    }
}

