/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.channel.address;

import java.util.List;
import java.util.Objects;
import java.util.Stack;
import kasuga.lib.core.KasugaLibStacks;
import kasuga.lib.core.channel.address.ChannelPort;
import kasuga.lib.core.channel.address.Label;
import net.minecraft.network.FriendlyByteBuf;

public class ConnectionInfo {
    Stack<Label> labels;
    ChannelPort port;

    public ConnectionInfo(Stack<Label> label, ChannelPort port) {
        this.labels = label;
        this.port = port;
    }

    public static ConnectionInfo of(Stack<Label> label, ChannelPort port) {
        return new ConnectionInfo(label, port);
    }

    public static ConnectionInfo of(Label label, ChannelPort port) {
        Stack<Label> labels = new Stack<Label>();
        labels.push(label);
        return new ConnectionInfo(labels, port);
    }

    public static ConnectionInfo of(ChannelPort port, Label ... labelList) {
        Stack<Label> labels = new Stack<Label>();
        labels.addAll(List.of(labelList));
        return new ConnectionInfo(labels, port);
    }

    public Stack<Label> getLabels() {
        return this.labels;
    }

    public Label lastAddress() {
        return this.labels.peek();
    }

    public Label firstAddress() {
        return (Label)this.labels.firstElement();
    }

    public Label address() {
        return this.lastAddress();
    }

    public Label popAddress() {
        return this.labels.pop();
    }

    public void pushAddress(Label label) {
        this.labels.push(label);
    }

    public ChannelPort getPort() {
        return this.port;
    }

    public void write(FriendlyByteBuf byteBuf) {
        byteBuf.writeInt(this.labels.size());
        for (Label label : this.labels) {
            KasugaLibStacks.CHANNEL.labelTypeRegistry.write(label, byteBuf);
        }
        this.port.write(byteBuf);
    }

    public static ConnectionInfo read(FriendlyByteBuf byteBuf) {
        Stack<Label> labels = new Stack<Label>();
        int size = byteBuf.readInt();
        for (int i = 0; i < size; ++i) {
            labels.push((Label)KasugaLibStacks.CHANNEL.labelTypeRegistry.read(byteBuf));
        }
        ChannelPort port = ChannelPort.read(byteBuf);
        return new ConnectionInfo(labels, port);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConnectionInfo that = (ConnectionInfo)object;
        return Objects.equals(this.labels, that.labels) && Objects.equals(this.port, that.port);
    }

    public int hashCode() {
        return Objects.hash(this.labels, this.port);
    }
}

