/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.channel.network;

import kasuga.lib.core.channel.network.NetworkDuplexer;
import kasuga.lib.core.channel.network.NetworkManager;
import kasuga.lib.core.channel.peer.Channel;
import kasuga.lib.core.channel.peer.ChannelSocket;
import net.minecraft.nbt.CompoundTag;

public class NetworkChannelSocket
implements ChannelSocket {
    private final NetworkManager manager;
    private final long networkId;
    private final NetworkDuplexer duplexer;
    private boolean internalClosed;
    private boolean internalEstablished;

    NetworkChannelSocket(NetworkManager manager, NetworkDuplexer duplexer, long networkId) {
        this.manager = manager;
        this.duplexer = duplexer;
        this.networkId = networkId;
    }

    @Override
    public void onMessage(CompoundTag message) {
        this.manager.sendMessage(this, message);
    }

    @Override
    public void onEstablished() {
        if (this.internalEstablished) {
            return;
        }
        this.internalEstablished = true;
        this.manager.sendEstablished(this);
    }

    @Override
    public void onClose() {
        if (this.internalClosed) {
            return;
        }
        this.internalClosed = true;
        this.duplexer.removeConnection(this.networkId);
        this.manager.sendClose(this);
    }

    @Override
    public void setChannel(Channel channel) {
    }

    public void internalClose() {
        this.internalClosed = true;
    }

    public long getNetworkId() {
        return this.networkId;
    }

    public boolean isDuplexedBy(NetworkDuplexer duplexer) {
        return this.duplexer == duplexer;
    }

    public void internalEstablish() {
        this.internalEstablished = true;
    }

    public NetworkDuplexer getDuplexer() {
        return this.duplexer;
    }
}

