/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.channel.network;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import kasuga.lib.core.channel.network.NetworkChannelSocket;
import kasuga.lib.core.channel.peer.Channel;
import net.minecraft.nbt.CompoundTag;

public class NetworkDuplexer {
    AtomicLong networkIdGenerator = new AtomicLong(1L);
    HashMap<Long, Channel> channels = new HashMap();
    HashMap<Long, NetworkChannelSocket> sockets = new HashMap();

    public long createConnection(Channel channel) {
        long networkId = this.networkIdGenerator.getAndIncrement();
        this.channels.put(networkId, channel);
        return networkId;
    }

    public boolean createConnection(Channel channel, long networkId) {
        if (this.channels.containsKey(networkId)) {
            return false;
        }
        this.channels.put(networkId, channel);
        return true;
    }

    public void establishConnection(long networkId, NetworkChannelSocket socket) {
        Channel channel = this.channels.get(networkId);
        if (channel == null) {
            return;
        }
        channel.establish(socket);
        this.sockets.put(networkId, socket);
    }

    public void sendMessageAsRemote(long networkId, CompoundTag message) {
        Channel channel = this.channels.get(networkId);
        NetworkChannelSocket socket = this.sockets.get(networkId);
        if (channel == null || socket == null) {
            return;
        }
        channel.sendMessage(socket, message);
    }

    public void closeConnection(long networkId) {
        Channel channel = this.channels.get(networkId);
        NetworkChannelSocket socket = this.sockets.get(networkId);
        if (channel == null) {
            return;
        }
        if (socket != null) {
            socket.internalClose();
        }
        channel.close();
        this.sockets.remove(networkId);
        this.channels.remove(networkId);
    }

    public void removeConnection(long networkId) {
        this.sockets.remove(networkId);
        this.channels.remove(networkId);
    }

    public void onExistedConnectionEstablished(long networkId, NetworkChannelSocket socket) {
        this.sockets.put(networkId, socket);
    }

    public void close() {
        List<Channel> currentChannels = List.copyOf(this.channels.values());
        for (Channel channel : currentChannels) {
            channel.close();
        }
        this.channels.clear();
        this.sockets.clear();
    }
}

