/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.channel.network;

import kasuga.lib.core.KasugaLibStacks;
import kasuga.lib.core.channel.address.ConnectionInfo;
import kasuga.lib.core.channel.network.NetworkChannelSocket;
import kasuga.lib.core.channel.network.NetworkDuplexer;
import kasuga.lib.core.channel.packets.C2SChannelConnectionPacket;
import kasuga.lib.core.channel.packets.C2SChannelMessagePacket;
import kasuga.lib.core.channel.packets.C2SChannelStateChangePacket;
import kasuga.lib.core.channel.peer.Channel;
import kasuga.lib.core.channel.peer.ChannelReciever;
import kasuga.lib.core.channel.peer.ChannelStatus;
import kasuga.lib.core.channel.route.SimpleRouter;
import net.minecraft.nbt.CompoundTag;

public class NetworkManager
implements ChannelReciever {
    NetworkDuplexer reciever = new NetworkDuplexer();
    NetworkDuplexer sender = new NetworkDuplexer();
    ChannelReciever _interface;

    public NetworkManager(SimpleRouter reciever) {
        this._interface = reciever;
        this.registerReciever(reciever);
    }

    protected void registerReciever(SimpleRouter reciever) {
        reciever.setDefaultReciever(this);
    }

    protected void unregisterReciever(SimpleRouter reciever) {
        reciever.setDefaultReciever(null);
    }

    @Override
    public void $onConnect(Channel channel) {
        long networkId = this.sender.createConnection(channel);
        this.sendNetworkConnecitonPacket(channel, networkId);
    }

    public void onConnection(ConnectionInfo sourceInfo, ConnectionInfo destInfo, long networkId) {
        if (!this.transform(sourceInfo, destInfo)) {
            this.sendStatePacket(networkId, ChannelStatus.CLOSED, false);
            return;
        }
        NetworkChannelSocket socket = new NetworkChannelSocket(this, this.reciever, networkId);
        Channel channel = new Channel(sourceInfo, destInfo, socket);
        if (!this.reciever.createConnection(channel, networkId)) {
            this.sendStatePacket(networkId, ChannelStatus.CLOSED, false);
            return;
        }
        this._interface.$onConnect(channel);
    }

    protected boolean transform(ConnectionInfo source, ConnectionInfo dest) {
        return true;
    }

    public void onStateUpdate(long networkId, ChannelStatus state, boolean isConnectionSender) {
        NetworkDuplexer duplexer = isConnectionSender ? this.reciever : this.sender;
        switch (state) {
            case ESTABLISHED: {
                NetworkChannelSocket socket = new NetworkChannelSocket(this, duplexer, networkId);
                socket.internalEstablish();
                duplexer.establishConnection(networkId, socket);
                break;
            }
            case CLOSED: {
                duplexer.closeConnection(networkId);
            }
        }
    }

    public void onMessage(long networkId, CompoundTag message, boolean isConnectionSender) {
        NetworkDuplexer duplexer = isConnectionSender ? this.reciever : this.sender;
        duplexer.sendMessageAsRemote(networkId, message);
    }

    public void sendMessage(NetworkChannelSocket channel, CompoundTag message) {
        boolean isOwn = channel.isDuplexedBy(this.sender);
        long networkId = channel.getNetworkId();
        this.sendMessagePacket(networkId, message, isOwn);
    }

    public void sendEstablished(NetworkChannelSocket socket) {
        long networkId = socket.getNetworkId();
        boolean isOwn = socket.isDuplexedBy(this.sender);
        this.sendStatePacket(networkId, ChannelStatus.ESTABLISHED, isOwn);
        socket.getDuplexer().onExistedConnectionEstablished(networkId, socket);
    }

    public void sendClose(NetworkChannelSocket socket) {
        long networkId = socket.getNetworkId();
        boolean isOwn = socket.isDuplexedBy(this.sender);
        this.sendStatePacket(networkId, ChannelStatus.CLOSED, isOwn);
    }

    protected void sendNetworkConnecitonPacket(Channel channel, long networkId) {
        if (!KasugaLibStacks.CHANNEL.clientIsEnabled()) {
            channel.close();
            return;
        }
        KasugaLibStacks.CHANNEL.packet.channelReg.sendToServer(new C2SChannelConnectionPacket(channel.source(), channel.destination(), networkId));
    }

    protected void sendMessagePacket(long networkId, CompoundTag message, boolean isOwn) {
        if (!KasugaLibStacks.CHANNEL.clientIsEnabled()) {
            return;
        }
        KasugaLibStacks.CHANNEL.packet.channelReg.sendToServer(new C2SChannelMessagePacket(networkId, message, isOwn));
    }

    protected void sendStatePacket(long networkId, ChannelStatus state, boolean isOwn) {
        if (!KasugaLibStacks.CHANNEL.clientIsEnabled()) {
            return;
        }
        KasugaLibStacks.CHANNEL.packet.channelReg.sendToServer(new C2SChannelStateChangePacket(networkId, state, isOwn));
    }

    public void close() {
        this.reciever.close();
        this.sender.close();
    }
}

