/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.channel.network;

import java.util.HashMap;
import kasuga.lib.core.channel.network.NetworkSeriaizableType;
import kasuga.lib.core.channel.network.NetworkSerializable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class NetworkSerializableRegistry<I extends NetworkSerializable, T extends NetworkSeriaizableType<? extends I>> {
    protected HashMap<ResourceLocation, NetworkSeriaizableType<?>> REGISTRY = new HashMap();
    protected HashMap<T, ResourceLocation> REVERSE_REGISTRY = new HashMap();

    public <P extends NetworkSeriaizableType<?>> P register(ResourceLocation name, P type) {
        this.REGISTRY.put(name, type);
        this.REVERSE_REGISTRY.put(type, name);
        return type;
    }

    public T get(ResourceLocation name) {
        return (T)this.REGISTRY.get(name);
    }

    public I read(ResourceLocation name, FriendlyByteBuf byteBuf) {
        return (I)((NetworkSeriaizableType)this.get(name)).read(byteBuf);
    }

    public I read(FriendlyByteBuf byteBuf) {
        T type = this.get(byteBuf.m_130281_());
        if (type == null) {
            throw new IllegalArgumentException("Unknown NetworkSerializable type: " + type);
        }
        return (I)((NetworkSeriaizableType)type).read(byteBuf);
    }

    public void write(I object, FriendlyByteBuf byteBuf) {
        ResourceLocation type = this.REVERSE_REGISTRY.get(object.getType());
        if (type == null) {
            throw new IllegalArgumentException("Unknown NetworkSerializable type: " + object.getType());
        }
        byteBuf.m_130085_(type);
        object.write(byteBuf);
    }
}

