/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.channel.network.address;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import kasuga.lib.core.channel.address.Label;
import kasuga.lib.core.channel.network.address.NetworkAddressTypes;
import net.minecraft.network.FriendlyByteBuf;

public class PlainStringAddress
extends Label {
    String name;

    protected PlainStringAddress() {
        super(NetworkAddressTypes.PLAIN_STRING);
    }

    public PlainStringAddress(String name) {
        this();
        this.name = name;
    }

    public PlainStringAddress(FriendlyByteBuf byteBuf) {
        this();
        int length = byteBuf.readInt();
        byte[] bytes = new byte[length];
        byteBuf.readBytes(bytes);
        this.name = new String(bytes, StandardCharsets.UTF_8);
    }

    public static PlainStringAddress of(String client) {
        return new PlainStringAddress(client);
    }

    @Override
    public void write(FriendlyByteBuf byteBuf) {
        byte[] bytes = this.name.getBytes(StandardCharsets.UTF_8);
        byteBuf.writeInt(bytes.length);
        byteBuf.writeBytes(bytes);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PlainStringAddress that = (PlainStringAddress)object;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

