/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.channel.packets;

import kasuga.lib.core.KasugaLibStacks;
import kasuga.lib.core.channel.address.ConnectionInfo;
import kasuga.lib.core.network.C2SPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class C2SChannelConnectionPacket
extends C2SPacket {
    ConnectionInfo sourceInfo;
    ConnectionInfo destInfo;
    long networkId;

    public C2SChannelConnectionPacket(ConnectionInfo sourceInfo, ConnectionInfo destInfo, long networkId) {
        this.sourceInfo = sourceInfo;
        this.destInfo = destInfo;
        this.networkId = networkId;
    }

    public C2SChannelConnectionPacket(FriendlyByteBuf byteBuf) {
        this.sourceInfo = ConnectionInfo.read(byteBuf);
        this.destInfo = ConnectionInfo.read(byteBuf);
        this.networkId = byteBuf.readLong();
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        KasugaLibStacks.CHANNEL.server(context.getSender()).onConnection(this.sourceInfo, this.destInfo, this.networkId);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        this.sourceInfo.write(buf);
        this.destInfo.write(buf);
        buf.writeLong(this.networkId);
    }

    public ConnectionInfo source() {
        return this.sourceInfo;
    }

    public ConnectionInfo destination() {
        return this.destInfo;
    }
}

