/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.channel.packets;

import kasuga.lib.core.KasugaLibStacks;
import kasuga.lib.core.channel.address.ConnectionInfo;
import kasuga.lib.core.network.S2CPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;

public class S2CChannelConnectionPacket
extends S2CPacket {
    ConnectionInfo sourceInfo;
    ConnectionInfo destInfo;
    long networkId;

    public S2CChannelConnectionPacket(ConnectionInfo sourceInfo, ConnectionInfo destInfo, long networkId) {
        this.sourceInfo = sourceInfo;
        this.destInfo = destInfo;
        this.networkId = networkId;
    }

    public S2CChannelConnectionPacket(FriendlyByteBuf byteBuf) {
        this.sourceInfo = ConnectionInfo.read(byteBuf);
        this.destInfo = ConnectionInfo.read(byteBuf);
        this.networkId = byteBuf.readLong();
    }

    @Override
    public void handle(Minecraft minecraft) {
        KasugaLibStacks.CHANNEL.client().onConnection(this.sourceInfo, this.destInfo, this.networkId);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        this.sourceInfo.write(buf);
        this.destInfo.write(buf);
        buf.writeLong(this.networkId);
    }

    public ConnectionInfo source() {
        return this.sourceInfo;
    }

    public ConnectionInfo destination() {
        return this.destInfo;
    }
}

