/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.channel.peer;

import java.util.ArrayList;
import java.util.List;
import kasuga.lib.core.channel.address.ConnectionInfo;
import kasuga.lib.core.channel.peer.ChannelCloseListener;
import kasuga.lib.core.channel.peer.ChannelSocket;
import kasuga.lib.core.channel.peer.ChannelStatus;
import net.minecraft.nbt.CompoundTag;

public class Channel {
    private final ConnectionInfo clientAddress;
    private final ConnectionInfo serverAddress;
    private ConnectionInfo proxySource;
    private ConnectionInfo proxyDest;
    private final ChannelSocket client;
    private final List<ChannelCloseListener> closeListeners = new ArrayList<ChannelCloseListener>();
    private ChannelSocket server;
    private ChannelStatus status = ChannelStatus.PENDING;

    public Channel(ConnectionInfo clientAddress, ConnectionInfo serverAddress, ChannelSocket client) {
        this.clientAddress = clientAddress;
        this.serverAddress = serverAddress;
        this.client = client;
        client.setChannel(this);
    }

    public void establish(ChannelSocket server) {
        this.server = server;
        this.client.onEstablished();
        this.server.onEstablished();
        this.status = ChannelStatus.ESTABLISHED;
        server.setChannel(this);
    }

    public void close() {
        if (this.status == ChannelStatus.CLOSED) {
            return;
        }
        this.status = ChannelStatus.CLOSED;
        if (this.server != null) {
            this.server.onClose();
        }
        if (this.client != null) {
            this.client.onClose();
        }
        for (ChannelCloseListener listener : this.closeListeners) {
            listener.onClose(this);
        }
    }

    public void sendMessage(boolean toServer, CompoundTag message) {
        if (toServer) {
            this.server.onMessage(message);
        } else {
            this.client.onMessage(message);
        }
    }

    public void sendMessage(ChannelSocket self, CompoundTag message) {
        this.sendMessage(self != this.server, message);
    }

    public void addOnCloseListener(ChannelCloseListener listener) {
        this.closeListeners.add(listener);
    }

    public ConnectionInfo source() {
        if (this.proxySource != null) {
            return this.proxySource;
        }
        return this.clientAddress;
    }

    public ConnectionInfo destination() {
        if (this.proxyDest != null) {
            return this.proxyDest;
        }
        return this.serverAddress;
    }

    public boolean isEstablished() {
        return this.status == ChannelStatus.ESTABLISHED;
    }

    public boolean isClient(Channel channel) {
        return this.client == channel;
    }

    public Channel proxy(ConnectionInfo newSource, ConnectionInfo newDest) {
        this.proxySource = newSource;
        this.proxyDest = newDest;
        return this;
    }
}

