/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.channel.peer;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import kasuga.lib.core.channel.peer.ChannelHandle;
import kasuga.lib.core.channel.peer.ChannelHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ChannelMultiplexer
implements ChannelHandler {
    private final Map<Integer, ChannelHandler> handlers = new HashMap<Integer, ChannelHandler>();
    private int nextIndex = 0;

    public int register(ChannelHandler handler) {
        int index = this.nextIndex++;
        this.handlers.put(index, handler);
        return index;
    }

    public ChannelMultiplexer with(Consumer<ChannelMultiplexer> consumer) {
        consumer.accept(this);
        return this;
    }

    @Override
    public void onChannelEstabilished(ChannelHandle channel) {
        this.handlers.values().forEach(handler -> handler.onChannelEstabilished(channel));
    }

    @Override
    public void onChannelMessage(ChannelHandle channel, CompoundTag payload) {
        int targetIndex = payload.m_128451_("T");
        int sourceIndex = payload.m_128451_("S");
        CompoundTag actualPayload = payload.m_128469_("P");
        ChannelHandler targetHandler = this.handlers.get(targetIndex);
        if (targetHandler != null) {
            targetHandler.onChannelMessage(channel, actualPayload);
        }
    }

    @Override
    public void onChannelClose(ChannelHandle channel) {
        this.handlers.values().forEach(handler -> handler.onChannelClose(channel));
    }

    public void sendMessage(ChannelHandle channel, int sourceIndex, int targetIndex, CompoundTag payload) {
        CompoundTag wrappedPayload = new CompoundTag();
        wrappedPayload.m_128405_("S", sourceIndex);
        wrappedPayload.m_128405_("T", targetIndex);
        wrappedPayload.m_128365_("P", (Tag)payload);
        channel.sendMessage(wrappedPayload);
    }
}

