/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.channel.peer;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kasuga.lib.core.channel.address.ChannelPort;
import kasuga.lib.core.channel.address.ConnectionInfo;
import kasuga.lib.core.channel.address.Label;
import kasuga.lib.core.channel.address.UUIDChannelPort;
import kasuga.lib.core.channel.peer.Channel;
import kasuga.lib.core.channel.peer.ChannelHandler;
import kasuga.lib.core.channel.peer.ChannelPeerSocketClient;
import kasuga.lib.core.channel.peer.ChannelPeerSocketServer;
import kasuga.lib.core.channel.peer.ChannelReciever;

public class ChannelPeer
implements ChannelReciever {
    Label address;
    private ChannelReciever distributor;
    private List<Channel> managedChannels = new ArrayList<Channel>();

    public ChannelPeer(Label address) {
        this.address = address;
    }

    public ChannelPeerSocketClient createSocket(ConnectionInfo remote) {
        ChannelPeerSocketClient client = new ChannelPeerSocketClient();
        UUIDChannelPort port = new UUIDChannelPort(UUID.randomUUID());
        Channel channel = new Channel(ConnectionInfo.of(this.address, (ChannelPort)port), remote, client);
        channel.addOnCloseListener(c -> this.managedChannels.remove(c));
        this.distributor.$onConnect(channel);
        return client;
    }

    public ChannelPeerSocketClient createSocket(ConnectionInfo remote, ChannelHandler handler) {
        ChannelPeerSocketClient client = new ChannelPeerSocketClient();
        client.setHandler(handler);
        UUIDChannelPort port = new UUIDChannelPort(UUID.randomUUID());
        Channel channel = new Channel(ConnectionInfo.of(this.address, (ChannelPort)port), remote, client);
        channel.addOnCloseListener(c -> this.managedChannels.remove(c));
        this.distributor.$onConnect(channel);
        return client;
    }

    @Override
    public void $onConnect(Channel channel) {
        ChannelPeerSocketServer server = new ChannelPeerSocketServer(channel);
        if (this.onConnect(server)) {
            channel.establish(server);
            channel.addOnCloseListener(c -> this.managedChannels.remove(c));
        } else {
            channel.close();
        }
    }

    protected boolean onConnect(ChannelPeerSocketServer server) {
        return false;
    }

    public void close() {
        for (Channel managedChannel : this.managedChannels) {
            managedChannel.close();
        }
    }

    public Label getAddress() {
        return this.address;
    }

    public void setDistributor(ChannelReciever distributor) {
        this.distributor = distributor;
    }
}

