/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.channel.route;

import java.util.Optional;
import kasuga.lib.core.channel.network.address.MinecraftClientPlayerAddress;
import kasuga.lib.core.channel.network.address.NetworkAddressTypes;
import kasuga.lib.core.channel.peer.Channel;
import kasuga.lib.core.channel.route.RouteRule;
import kasuga.lib.core.channel.route.RouteTarget;
import net.minecraft.server.level.ServerPlayer;

public class PlayerLabelMatchRule
implements RouteRule {
    private final RouteTarget target;
    private final ServerPlayer player;

    @Override
    public Optional<RouteTarget> route(Channel channel) {
        if (channel.destination().address().getType() == NetworkAddressTypes.PLAYER_ADDRESS && ((MinecraftClientPlayerAddress)channel.destination().address()).getPlayer() == this.player) {
            return Optional.of(this.target);
        }
        return Optional.empty();
    }

    public PlayerLabelMatchRule(RouteTarget target, ServerPlayer player) {
        this.target = target;
        this.player = player;
    }

    public static PlayerLabelMatchRule create(ServerPlayer player, RouteTarget target) {
        return new PlayerLabelMatchRule(target, player);
    }
}

