/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.channel.route;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import kasuga.lib.core.channel.address.Label;
import kasuga.lib.core.channel.peer.Channel;
import kasuga.lib.core.channel.peer.ChannelPeer;
import kasuga.lib.core.channel.peer.ChannelReciever;
import kasuga.lib.core.channel.route.RouteRule;
import kasuga.lib.core.channel.route.RouteRuleManager;
import kasuga.lib.core.channel.route.RouteTarget;

public class SimpleRouter
extends RouteRuleManager
implements ChannelReciever {
    HashMap<Label, ChannelReciever> directPeers = new HashMap();
    private ChannelReciever defaultReciever;
    private final Set<Channel> activeChannels = new HashSet<Channel>();

    @Override
    public void $onConnect(Channel channel) {
        this.activeChannels.add(channel);
        channel.addOnCloseListener(c -> this.activeChannels.remove(channel));
        Label next = channel.destination().address();
        if (this.directPeers.containsKey(next)) {
            this.directPeers.get(next).$onConnect(channel);
            return;
        }
        for (RouteRule rule : this.rules) {
            Optional<RouteTarget> target = rule.route(channel);
            if (!target.isPresent()) continue;
            target.get().distribute(channel, this);
            return;
        }
        if (this.defaultReciever != null) {
            this.defaultReciever.$onConnect(channel);
            return;
        }
        channel.close();
    }

    public void attach(ChannelPeer peer) {
        this.directPeers.put(peer.getAddress(), peer);
        peer.setDistributor(this);
    }

    public void detach(ChannelPeer peer) {
        this.directPeers.remove(peer.getAddress());
        peer.setDistributor(null);
    }

    public void setDefaultReciever(ChannelReciever reciever) {
        this.defaultReciever = reciever;
    }

    public void addPeer(ChannelPeer clientPeer) {
        this.directPeers.put(clientPeer.getAddress(), clientPeer);
        clientPeer.setDistributor(this);
    }

    public void removePeer(ChannelPeer clientPeer) {
        this.directPeers.remove(clientPeer.getAddress());
        clientPeer.setDistributor(null);
    }

    public void close() {
        for (Channel channel : this.activeChannels) {
            channel.close();
        }
        this.activeChannels.clear();
        for (ChannelReciever peer : this.directPeers.values()) {
            if (!(peer instanceof ChannelPeer)) continue;
            ((ChannelPeer)peer).close();
        }
        this.directPeers.clear();
        this.defaultReciever = null;
    }
}

