/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.channel.test;

import kasuga.lib.core.KasugaLibStacks;
import kasuga.lib.core.base.commands.CommandHandler;
import kasuga.lib.core.channel.NetworkSwitcher;
import kasuga.lib.core.channel.address.ConnectionInfo;
import kasuga.lib.core.channel.address.FeatureChannelPort;
import kasuga.lib.core.channel.address.Label;
import kasuga.lib.core.channel.network.address.MinecraftServerAddress;
import kasuga.lib.core.channel.network.address.NetworkAddressTypes;
import kasuga.lib.core.channel.network.address.PlainStringAddress;
import kasuga.lib.core.channel.peer.ChannelHandle;
import kasuga.lib.core.channel.peer.ChannelHandler;
import kasuga.lib.core.channel.peer.ChannelPeer;
import kasuga.lib.core.channel.peer.ChannelPeerSocketClient;
import kasuga.lib.core.channel.peer.ChannelPeerSocketServer;
import kasuga.lib.core.channel.route.ForwardRouteTarget;
import kasuga.lib.core.channel.route.SimpleRouter;
import kasuga.lib.core.channel.route.TargetLabelMatchRule;
import kasuga.lib.registrations.common.CommandReg;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class ChannelTest {
    public static boolean serverInitilized = false;
    public static final CommandReg NET_CLIENT = new CommandReg("kasugalib").addLiteral("networking", false).addLiteral("client", false).setHandler(new CommandHandler(){

        @Override
        public void run() {
            ChannelTest.runAtClient();
        }
    }).submit(KasugaLibStacks.REGISTRY);
    public static final CommandReg NET_SERVER = new CommandReg("kasugalib").addLiteral("networking", false).addLiteral("server", false).setHandler(new CommandHandler(){

        @Override
        public void run() {
            ChannelTest.runAtServer();
        }
    }).submit(KasugaLibStacks.REGISTRY);

    public static void runAtClient() {
        ChannelPeer clientPeer = new ChannelPeer(PlainStringAddress.of("client"));
        SimpleRouter clientRouter = new SimpleRouter();
        clientRouter.setDefaultReciever(KasugaLibStacks.CHANNEL.CLIENT_ROUTER);
        clientPeer.setDistributor(clientRouter);
        ChannelPeerSocketClient channel = clientPeer.createSocket(ConnectionInfo.of(FeatureChannelPort.of(new ResourceLocation("kasuga_lib", "test")), PlainStringAddress.of("server"), (Label)MinecraftServerAddress.INSTANCE.get()), new ChannelHandler(){

            @Override
            public void onChannelEstabilished(ChannelHandle channel) {
                System.out.println("[Client] Channel Established");
                channel.sendMessage(new CompoundTag());
            }

            @Override
            public void onChannelMessage(ChannelHandle channel, CompoundTag payload) {
                System.out.println("[Client] Channel Message Recieved");
            }

            @Override
            public void onChannelClose(ChannelHandle channel) {
                System.out.println("[Client] Channel closed");
            }
        });
    }

    public static void runAtServer() {
        if (serverInitilized) {
            return;
        }
        serverInitilized = true;
        ChannelPeer serverPeer = new ChannelPeer(PlainStringAddress.of("server")){

            @Override
            protected boolean onConnect(ChannelPeerSocketServer server) {
                System.out.println("[Server] Channel Connected");
                server.setHandler(new ChannelHandler(){

                    @Override
                    public void onChannelEstabilished(ChannelHandle channel) {
                        System.out.println("[Server] Channel Established");
                    }

                    @Override
                    public void onChannelMessage(ChannelHandle channel, CompoundTag payload) {
                        System.out.println("[Server] Channel Message");
                        channel.sendMessage(new CompoundTag());
                    }

                    @Override
                    public void onChannelClose(ChannelHandle channel) {
                        System.out.println("[Server] Channel Closed");
                    }
                });
                return true;
            }
        };
        NetworkSwitcher switcher = new NetworkSwitcher();
        switcher.addPeer(serverPeer);
        KasugaLibStacks.CHANNEL.SERVER_ROUTER.addRule(TargetLabelMatchRule.create(NetworkAddressTypes.PLAIN_STRING, ForwardRouteTarget.create(switcher)));
    }

    public static void invoke() {
    }
}

