/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.data.bones;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kasuga.lib.core.client.animation.data.Animation;
import kasuga.lib.core.client.animation.infrastructure.AnimAssignable;
import kasuga.lib.core.client.animation.infrastructure.AnimationElement;
import kasuga.lib.core.client.animation.infrastructure.Condition;
import kasuga.lib.core.client.animation.infrastructure.IAnchor;
import kasuga.lib.core.client.render.PoseContext;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import kasuga.lib.vendor_modules.interpreter.compute.data.functions.Function;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Formula;
import kasuga.lib.vendor_modules.interpreter.logic.data.LogicalBool;
import kasuga.lib.vendor_modules.interpreter.logic.infrastructure.LogicalData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BoneMovement
extends AnimationElement
implements AnimAssignable,
IAnchor {
    String bone;
    private final Namespace namespace;
    private IAnchor.AnchorContext context = ZERO;
    private IAnchor.AnchorInvoker invoker = null;
    private final ArrayList<Pair<Formula, PoseContext.Action>> actions;
    private final ArrayList<Pair<Formula, PoseContext.ActionType>> types;
    private final Animation animation;
    private IAnchor parent = null;
    @Nonnull
    Condition condition;
    @Nonnull
    Condition shouldDisplay;

    public BoneMovement(String key, String bone, Namespace namespace, Animation animation) {
        super(key);
        this.bone = bone;
        this.animation = animation;
        this.namespace = namespace;
        this.condition = Condition.defaultFalse(key, namespace);
        this.shouldDisplay = Condition.defaultTrue(key, namespace);
        this.actions = new ArrayList();
        this.types = new ArrayList();
    }

    public BoneMovement(String key, String bone, String code, Namespace namespace, Animation animation) {
        this(key, bone, namespace, animation);
        this.decodeFormula(code);
    }

    public void decodeFormula(String code) {
        Formula formula = this.namespace.decodeFormula(code);
        if (formula instanceof Function) {
            Function f = (Function)formula;
            String codec = f.getCodec();
            PoseContext.Action action = null;
            switch (codec) {
                case "translate": {
                    if (f.paramCount() == 1) {
                        action = this.translate(this.animation.getAsAnchor(f.getParams().get(0).toString()));
                        this.types.add(Pair.of(f, PoseContext.ActionType.TRANSLATE));
                        break;
                    }
                    if (f.paramCount() < 3) break;
                    action = this.translate(f.getParams().get(0), f.getParams().get(1), f.getParams().get(2));
                    this.types.add(Pair.of(f, PoseContext.ActionType.TRANSLATE));
                    break;
                }
                case "x_rot": {
                    if (f.paramCount() < 1) break;
                    action = this.xRot(f.getParams().get(0));
                    this.types.add(Pair.of(f, PoseContext.ActionType.X_ROT));
                    break;
                }
                case "y_rot": {
                    if (f.paramCount() < 1) break;
                    action = this.yRot(f.getParams().get(0));
                    this.types.add(Pair.of(f, PoseContext.ActionType.Y_ROT));
                    break;
                }
                case "z_rot": {
                    if (f.paramCount() < 1) break;
                    action = this.zRot(f.getParams().get(0));
                    this.types.add(Pair.of(f, PoseContext.ActionType.Z_ROT));
                    break;
                }
                case "x_rot_rad": {
                    if (f.paramCount() < 1) break;
                    action = this.xRotRad(f.getParams().get(0));
                    this.types.add(Pair.of(f, PoseContext.ActionType.X_ROT));
                    break;
                }
                case "y_rot_rad": {
                    if (f.paramCount() < 1) break;
                    action = this.yRotRad(f.getParams().get(0));
                    this.types.add(Pair.of(f, PoseContext.ActionType.Y_ROT));
                    break;
                }
                case "z_rot_rad": {
                    if (f.paramCount() < 1) break;
                    action = this.zRotRad(f.getParams().get(0));
                    this.types.add(Pair.of(f, PoseContext.ActionType.Z_ROT));
                    break;
                }
                case "scale": {
                    if (f.paramCount() == 1) {
                        action = this.scale(this.animation.getAsAnchor(f.getParams().get(0).toString()));
                        this.types.add(Pair.of(f, PoseContext.ActionType.SCALE));
                        break;
                    }
                    if (f.paramCount() < 3) break;
                    action = this.scale(f.getParams().get(0), f.getParams().get(1), f.getParams().get(2));
                    this.types.add(Pair.of(f, PoseContext.ActionType.SCALE));
                    break;
                }
                case "point_to": {
                    if (f.paramCount() == 1) {
                        action = this.pointTo(this.animation.getAsAnchor(f.getParams().get(0).toString()));
                        this.types.add(Pair.of(f, PoseContext.ActionType.POINT_TO));
                        break;
                    }
                    if (f.paramCount() < 3) break;
                    action = this.pointTo(f.getParams().get(0), f.getParams().get(1), f.getParams().get(2));
                    this.types.add(Pair.of(f, PoseContext.ActionType.POINT_TO));
                }
            }
            if (action != null) {
                this.actions.add(Pair.of(f, action));
            }
        }
    }

    @Nullable
    public Pair<Formula, PoseContext.Action> getAction(Formula formula) {
        for (Pair<Formula, PoseContext.Action> pair : this.actions) {
            if (!pair.getFirst().equals(formula)) continue;
            return pair;
        }
        return null;
    }

    public PoseContext.Action[] getAllActions() {
        PoseContext.Action[] result = new PoseContext.Action[this.actions.size()];
        int counter = 0;
        for (Pair<Formula, PoseContext.Action> pair : this.actions) {
            result[counter] = pair.getSecond();
            ++counter;
        }
        return result;
    }

    public void setParent(IAnchor parent) {
        this.parent = parent;
    }

    @Override
    public ArrayList<Pair<Formula, PoseContext.ActionType>> getMoves() {
        return this.types;
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void updateVars() {
        this.namespace.assign(this.key() + ".x", this.context.x());
        this.namespace.assign(this.key() + ".y", this.context.y());
        this.namespace.assign(this.key() + ".z", this.context.z());
        this.namespace.assign(this.key() + ".x_rot", this.context.x_rot());
        this.namespace.assign(this.key() + ".y_rot", this.context.y_rot());
        this.namespace.assign(this.key() + ".z_rot", this.context.z_rot());
        this.namespace.assign(this.key() + ".x_scale", this.context.x_scale());
        this.namespace.assign(this.key() + ".y_scale", this.context.y_scale());
        this.namespace.assign(this.key() + ".z_scale", this.context.z_scale());
    }

    public Pair<Formula, PoseContext.Action> getAction(int index) {
        return this.actions.get(index);
    }

    public void setCondition(@Nonnull String logical) {
        this.condition.fromString(Objects.requireNonNull(logical));
    }

    public void setDisplayCondition(@Nonnull String condition) {
        this.shouldDisplay.fromString(Objects.requireNonNull(condition));
    }

    @Override
    public boolean isAssignable() {
        return this.isValid() && (this.namespace.hasInstance() || this.condition.isAssignable() || this.shouldDisplay.isAssignable());
    }

    @Override
    public void init() {
    }

    public static BoneMovement decode(String bone, Namespace namespace, Animation animation, JsonObject object) {
        LogicalData render = LogicalBool.defaultTrue();
        LogicalData condition = LogicalBool.defaultTrue();
        BoneMovement movement = new BoneMovement("bone", bone, namespace, animation);
        if (object.has("render")) {
            render = movement.getCondition(object.get("render"));
        }
        if (object.has("condition")) {
            condition = movement.getCondition(object.get("condition"));
        }
        JsonArray functions = object.getAsJsonArray("action");
        for (JsonElement element : functions) {
            movement.decodeFormula(element.getAsString());
        }
        movement.condition = new Condition("condition", namespace, condition);
        movement.shouldDisplay = new Condition("render", namespace, render);
        if (bone.contains(".")) {
            String[] path = bone.split("\\.");
            if (path.length > 1) {
                String p = path[path.length - 2];
                movement.invoker = () -> {
                    if (animation.containsAnchor(p)) {
                        movement.setParent(animation.getAsAnchor(p));
                    } else if (animation.containsAsAnchor("this")) {
                        movement.setParent(animation.getAsAnchor("this"));
                    }
                };
            }
        } else if (!bone.equals("this")) {
            movement.invoker = () -> {
                if (animation.containsAsAnchor("this")) {
                    movement.setParent(animation.getAsAnchor("this"));
                }
            };
        }
        return movement;
    }

    public void invoke() {
        if (this.invoker == null) {
            return;
        }
        this.invoker.invoke();
    }

    private LogicalData getCondition(JsonElement element) {
        String def = element.getAsString();
        if (def.equals("true") || def.equals("false")) {
            def = def.equals("true") ? "True" : "False";
        }
        return this.namespace.decodeLogical(def);
    }

    public void action(PoseStack pose) {
        if (!this.condition.result()) {
            return;
        }
        for (Pair<Formula, PoseContext.Action> pair : this.actions) {
            pair.getSecond().action(pose);
        }
    }

    public boolean shouldDisplay() {
        return this.shouldDisplay.result();
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public IAnchor getParent() {
        return this.parent;
    }

    @Override
    public void assign(String codec, float value) {
        this.namespace.assign(codec, value);
    }

    public ArrayList<Pair<Formula, PoseContext.Action>> getAction() {
        return this.actions;
    }

    public boolean shouldAct() {
        return this.isValid() && this.condition.result();
    }

    @Override
    public boolean isValid() {
        return !this.actions.isEmpty();
    }

    public PoseContext.Action translate(Formula fx, Formula fy, Formula fz) {
        return pose -> pose.m_85837_((double)fx.getResult(), (double)fy.getResult(), (double)fz.getResult());
    }

    public PoseContext.Action translate(IAnchor anchor) {
        return pose -> {
            IAnchor.AnchorContext context = anchor.getMovement();
            pose.m_85837_((double)context.x(), (double)context.y(), (double)context.z());
        };
    }

    public PoseContext.Action xRot(Formula fx) {
        return pose -> pose.m_85845_(Vector3f.f_122223_.m_122240_(fx.getResult()));
    }

    public PoseContext.Action yRot(Formula fy) {
        return pose -> pose.m_85845_(Vector3f.f_122225_.m_122240_(fy.getResult()));
    }

    public PoseContext.Action zRot(Formula fz) {
        return pose -> pose.m_85845_(Vector3f.f_122227_.m_122240_(fz.getResult()));
    }

    public PoseContext.Action xRotRad(Formula fx) {
        return pose -> pose.m_85845_(Vector3f.f_122223_.m_122270_(fx.getResult()));
    }

    public PoseContext.Action yRotRad(Formula fy) {
        return pose -> pose.m_85845_(Vector3f.f_122225_.m_122270_(fy.getResult()));
    }

    public PoseContext.Action zRotRad(Formula fz) {
        return pose -> pose.m_85845_(Vector3f.f_122227_.m_122270_(fz.getResult()));
    }

    public PoseContext.Action scale(Formula fx, Formula fy, Formula fz) {
        return pose -> pose.m_85841_(fx.getResult(), fy.getResult(), fz.getResult());
    }

    public PoseContext.Action scale(IAnchor anchor) {
        return pose -> {
            IAnchor.AnchorContext context = anchor.getMovement();
            IAnchor.AnchorContext context1 = this.getMovement();
            pose.m_85841_(context.x_scale() / context1.x_scale(), context.y_scale() / context1.x_scale(), context.z_scale() / context1.z_scale());
        };
    }

    public PoseContext.Action pointTo(IAnchor anchor) {
        return pose -> {
            IAnchor.AnchorContext context1 = this.getMovement();
            IAnchor.AnchorContext context2 = anchor.getMovement();
            pose.m_85845_(Vector3f.f_122223_.m_122240_(context2.x_rot() - context1.x_rot()));
            pose.m_85845_(Vector3f.f_122225_.m_122240_(context2.y_rot() - context1.y_rot()));
            pose.m_85845_(Vector3f.f_122227_.m_122240_(context2.z_rot() - context1.z_rot()));
        };
    }

    public PoseContext.Action pointTo(Formula px, Formula py, Formula pz) {
        return pose -> {
            pose.m_85845_(Vector3f.f_122223_.m_122240_(px.getResult()));
            pose.m_85845_(Vector3f.f_122225_.m_122240_(py.getResult()));
            pose.m_85845_(Vector3f.f_122227_.m_122240_(pz.getResult()));
        };
    }

    @Override
    public IAnchor.AnchorContext getMovement() {
        this.context = this.innerMove();
        return this.context;
    }

    public static float cos(float deg) {
        return (float)Math.cos(Math.toRadians(deg));
    }

    public static float sin(float deg) {
        return (float)Math.sin(Math.toRadians(deg));
    }
}

