/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.infrastructure;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kasuga.lib.core.client.render.model.MultiPartModel;
import kasuga.lib.core.client.render.model.SimpleModel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MappingLayer {
    private SimpleModel model;
    private final HashMap<String, SimpleModel> mapping = new HashMap();

    public MappingLayer() {
    }

    public MappingLayer(SimpleModel model) {
        this();
        this.model = model;
    }

    public void buildMapping() {
        this.mapping.put("this", this.model);
        SimpleModel simpleModel = this.model;
        if (simpleModel instanceof MultiPartModel) {
            MultiPartModel multiPartModel = (MultiPartModel)simpleModel;
            HashMap<String, SimpleModel> cache = new HashMap<String, SimpleModel>(multiPartModel.getBoneMap());
            for (SimpleModel model1 : cache.values()) {
                this.scanModel(model1, "");
            }
        }
    }

    public SimpleModel getModel() {
        return this.model;
    }

    public void setModel(SimpleModel model) {
        this.model = model;
    }

    public void rebuildMapping(SimpleModel model) {
        this.setModel(model);
        this.rebuildMapping();
    }

    public void rebuildMapping() {
        this.mapping.clear();
        this.buildMapping();
    }

    public HashMap<String, SimpleModel> getMapping() {
        return this.mapping;
    }

    public void replaceMapping(String oldKeyName, String newKeyName) {
        HashSet keySet = new HashSet();
        this.mapping.keySet().forEach(codec -> {
            if (codec.contains(oldKeyName)) {
                keySet.add(codec);
            }
        });
        for (String key : keySet) {
            this.mapping.put(key.replace(oldKeyName, newKeyName), this.mapping.get(key));
            this.mapping.remove(key);
        }
    }

    private void scanModel(SimpleModel model, String prefix) {
        String keyName = prefix.equals("") ? model.key : prefix + "." + model.key;
        this.mapping.put(keyName, model);
        if (model instanceof MultiPartModel) {
            MultiPartModel multiPartModel = (MultiPartModel)model;
            Map<String, SimpleModel> boneMap = multiPartModel.getBoneMap();
            for (SimpleModel modelx : boneMap.values()) {
                this.scanModel(modelx, keyName);
            }
        }
    }
}

