/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.neo_neo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kasuga.lib.core.client.animation.neo_neo.base.Movement;
import kasuga.lib.core.client.animation.neo_neo.key_frame.KeyFrame;
import kasuga.lib.core.client.animation.neo_neo.key_frame.KeyFrameHolder;
import kasuga.lib.core.util.data_type.Pair;
import net.minecraft.resources.ResourceLocation;

public class StateHolder<T extends Movement> {
    private String name;
    private final HashMap<String, HashMap<Float, KeyFrame<? extends T>>> holder;
    private final KeyFrameHolder<T> keyFrameBase;

    public StateHolder(KeyFrameHolder<T> base, String name) {
        this.name = name;
        this.holder = new HashMap();
        this.keyFrameBase = base;
    }

    public HashMap<String, HashMap<Float, KeyFrame<? extends T>>> getHolder() {
        return this.holder;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addBone(String boneKey) {
        if (!this.holder.containsKey(boneKey)) {
            this.holder.put(boneKey, new HashMap());
        }
    }

    public HashMap<Float, KeyFrame<? extends T>> getKeyFrames(String bone) {
        return this.holder.getOrDefault(bone, new HashMap());
    }

    public boolean containsBone(String bone) {
        return this.holder.containsKey(bone);
    }

    public boolean removeBone(String bone) {
        if (!this.holder.containsKey(bone)) {
            return false;
        }
        this.holder.remove(bone);
        return true;
    }

    public void addKeyFrame(String bone, Float time, KeyFrame<? extends T> frame) {
        if (this.containsBone(bone)) {
            this.addBone(bone);
        }
        this.holder.get(bone).put(time, frame);
    }

    public void addKeyFrame(String bone, Float time, ResourceLocation location) {
        if (!this.keyFrameBase.contains(location)) {
            return;
        }
        this.addKeyFrame(bone, time, this.keyFrameBase.get(location));
    }

    public int getFrameCount(String bone) {
        if (!this.containsBone(bone)) {
            return 0;
        }
        return this.getKeyFrames(bone).size();
    }

    public int boneCount() {
        return this.holder.size();
    }

    public boolean isEmpty() {
        return this.holder.isEmpty();
    }

    public void cutEmptyLeaves() {
        LinkedList bone = new LinkedList();
        this.holder.forEach((a, b) -> {
            if (b.isEmpty()) {
                bone.add(a);
            }
        });
        bone.forEach(this.holder::remove);
    }

    public List<Pair<Float, KeyFrame<? extends T>>> getFramesByTime(String bone) {
        if (!this.holder.containsKey(bone)) {
            return List.of();
        }
        HashMap<Float, KeyFrame<T>> frames = this.holder.get(bone);
        ArrayList result = new ArrayList(frames.size());
        frames.forEach((a, b) -> result.add(Pair.of(a, b)));
        boolean shouldSort = true;
        while (shouldSort) {
            shouldSort = false;
            for (int i = 1; i < result.size(); ++i) {
                Pair<Float, KeyFrame<T>> cache = result.get(i);
                if (!(cache.getFirst().floatValue() < result.get(i - 1).getFirst().floatValue())) continue;
                result.set(i, result.get(i - 1));
                result.set(i - 1, cache);
                shouldSort = true;
            }
        }
        return result;
    }
}

