/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.neo_neo.scaling;

import com.mojang.blaze3d.vertex.PoseStack;
import kasuga.lib.core.client.animation.neo_neo.VectorUtil;
import kasuga.lib.core.client.animation.neo_neo.base.ICustom;
import kasuga.lib.core.client.animation.neo_neo.scaling.Scaling;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.vendor_modules.interpreter.Code;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Formula;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;

public class CustomScaling
extends Scaling
implements ICustom {
    private final Namespace namespace;
    Formula x;
    Formula y;
    Formula z;
    private Pair<Float, Vec3> cache;

    public CustomScaling(Namespace namespace, String x, String y, String z, float startTime, float endTime) {
        super(STARTER, startTime, endTime);
        this.namespace = namespace;
        this.x = namespace.decodeFormula(x);
        this.y = namespace.decodeFormula(y);
        this.z = namespace.decodeFormula(z);
        this.cache = Pair.of(Float.valueOf(0.0f), STARTER);
        namespace.assign("start_time", startTime);
        namespace.assign("end_time", endTime);
    }

    public CustomScaling(String x, String y, String z, float startTime, float endTime) {
        this(new Namespace(Code.ROOT_NAMESPACE), x, y, z, startTime, endTime);
    }

    public CustomScaling(Namespace namespace, float startTime, float endTime) {
        this(namespace, "0", "0", "0", startTime, endTime);
    }

    public CustomScaling(float startTime, float endTime) {
        this(new Namespace(Code.ROOT_NAMESPACE), startTime, endTime);
    }

    @Override
    public void setX(String x) {
        this.x = this.namespace.decodeFormula(x);
    }

    @Override
    public void setY(String y) {
        this.y = this.namespace.decodeFormula(y);
    }

    @Override
    public void setZ(String z) {
        this.z = this.namespace.decodeFormula(z);
    }

    @Override
    public Formula getX() {
        return this.x;
    }

    @Override
    public Formula getY() {
        return this.y;
    }

    @Override
    public Formula getZ() {
        return this.z;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public void setStartTime(float startTime) {
        super.setStartTime(startTime);
        this.namespace.assign("start_time", startTime);
    }

    @Override
    public void setEndTime(float endTime) {
        super.setEndTime(endTime);
        this.namespace.assign("end_time", endTime);
    }

    @Override
    public Vec3 getPercentage(float percentage) {
        if (this.cache.getFirst().equals(Float.valueOf(percentage))) {
            return this.cache.getSecond();
        }
        this.namespace.assign("t", percentage);
        Vec3 result = new Vec3((double)this.x.getResult(), (double)this.y.getResult(), (double)this.z.getResult());
        result = STARTER.m_82549_(STARTER.m_82546_(result));
        this.cache = Pair.of(Float.valueOf(percentage), result);
        return result;
    }

    @Override
    public void move(float time, PoseStack pose) {
        VectorUtil.scale(pose, this.getPercentage(time));
    }

    @Override
    public void read(CompoundTag nbt) {
        super.read(nbt);
        this.readCustomFormulas(nbt, "custom");
    }

    @Override
    public void write(CompoundTag nbt) {
        super.write(nbt);
        this.writeCustomFormulas(nbt, "custom");
    }
}

