/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.commands;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.KasugaLibStacks;
import kasuga.lib.core.addons.node.NodePackage;
import kasuga.lib.core.base.commands.CommandHandler;
import kasuga.lib.core.client.frontend.commands.GuiScreenHelper;
import kasuga.lib.core.client.frontend.commands.MetroLoaderModule;
import kasuga.lib.core.client.frontend.commands.MetroModuleInfo;
import kasuga.lib.core.client.frontend.commands.MetroModuleLoader;
import kasuga.lib.core.client.frontend.commands.MetroServerResourceProvider;
import kasuga.lib.core.javascript.JavascriptContext;
import kasuga.lib.core.javascript.JavascriptThread;
import kasuga.lib.registrations.common.CommandReg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import kasuga.lib.vendor_modules.org.apache.http.impl.client.CloseableHttpClient;
import kasuga.lib.vendor_modules.org.apache.http.impl.client.HttpClients;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class FrontendCommands {
    public static final SimpleRegistry REGISTRY = KasugaLibStacks.REGISTRY;
    protected static final CloseableHttpClient client = HttpClients.createDefault();
    public static final CommandReg GUI_DEBUG_COMMAND = new CommandReg("kasugalib").addLiteral("gui", false).addLiteral("debug", false).onlyIn(Dist.CLIENT).setHandler(new CommandHandler(){

        @Override
        public void run() {
            MetroServerResourceProvider resourceProvider = new MetroServerResourceProvider();
            UUID contextId = UUID.randomUUID();
            CompletableFuture<JavascriptThread> threadFuture = MetroModuleLoader.getThread();
            threadFuture.thenAccept(thread -> thread.recordCall(() -> {
                NodePackage nodePackage = null;
                try (InputStream inputStream = resourceProvider.open("/package.json");){
                    InputStreamReader reader = new InputStreamReader(inputStream);
                    JsonObject json = (JsonObject)KasugaLib.GSON.fromJson((Reader)reader, JsonObject.class);
                    nodePackage = NodePackage.parse(json, null);
                }
                catch (IOException e) {
                    return;
                }
                nodePackage.minecraft.clientDebuggerEntries().forEach(entry -> {
                    JavascriptContext context = thread.createContext(entry, "Debugger Context - " + entry);
                    MetroModuleInfo moduleInfo = new MetroModuleInfo(resourceProvider.getServerAddress(), resourceProvider);
                    MetroLoaderModule loaderModule = new MetroLoaderModule(moduleInfo);
                    String session = MetroModuleLoader.createSession(moduleInfo);
                    context.loadModuleVoid("metro-session:" + session + "/" + entry);
                });
            }));
        }
    }).submit(REGISTRY);
    public static final CommandReg GUI_OPEN = new CommandReg("kasugalib").addLiteral("gui", false).addLiteral("open", false).addResourceLocation("id", false).onlyIn(Dist.CLIENT).setHandler(new CommandHandler(){

        @Override
        public void run() {
            if (KasugaLib.STACKS.GUI.isEmpty()) {
                return;
            }
            ResourceLocation id = this.getParameter("id", ResourceLocation.class);
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> GuiScreenHelper.createAndAttach(id));
        }
    }).submit(REGISTRY);
    public static final CommandReg GUI_INSTANCES_LIST = new CommandReg("kasugalib").addLiteral("gui", false).addLiteral("instances", false).addLiteral("list", false).onlyIn(Dist.CLIENT).setHandler(new CommandHandler(){

        @Override
        public void run() {
            Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)"-------- GUI Instances --------"));
            KasugaLib.STACKS.GUI.ifPresent(gui -> gui.getAllInstances().forEach((id, instance) -> Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)id.toString().substring(0, 8)).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)instance.getLocation().toString())).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)"[Inspect]").m_130938_(s -> s.m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/kasugalib gui instances inspect " + id)))).m_130938_(s -> s.m_131148_(TextColor.m_131268_((String)"#ffff00"))))));
        }
    }).submit(REGISTRY);
    public static final CommandReg GUI_INSPECT = new CommandReg("kasugalib").addLiteral("gui", false).addLiteral("instances", false).addLiteral("inspect", false).addString("id", false).onlyIn(Dist.CLIENT).setHandler(new CommandHandler(){

        @Override
        public void run() {
            if (KasugaLib.STACKS.GUI.isEmpty()) {
                return;
            }
            UUID id = UUID.fromString(this.getParameter("id", String.class));
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> GuiScreenHelper.attach(id));
        }
    }).submit(REGISTRY);

    public static void invoke() {
        REGISTRY.submit();
    }
}

