/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.common.style;

import com.caoccao.javet.annotations.V8Convert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import kasuga.lib.core.client.frontend.common.style.Style;
import kasuga.lib.core.client.frontend.common.style.StyleRegistry;
import kasuga.lib.core.client.frontend.common.style.StyleStates;
import kasuga.lib.core.client.frontend.common.style.StyleType;
import kasuga.lib.core.javascript.engine.annotations.HostAccess;
import kasuga.lib.core.util.Callback;

@V8Convert
public class StyleList<R> {
    private final StyleRegistry<R> styleRegistry;
    public final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    protected List<Style<?, R>> styles = new ArrayList();
    protected Map<StyleType<?, R>, Style<?, R>> cache = new HashMap();
    protected WeakHashMap<Object, Boolean> styleUpdate = new WeakHashMap();
    public Callback callback = null;

    public StyleList(StyleRegistry<R> registry) {
        this.styleRegistry = registry;
    }

    public void freshCache() {
        this.cache.clear();
        this.freshCache(null);
        this.setHasNewStyle();
    }

    public int freshCache(StyleType<?, R> type) {
        ReentrantReadWriteLock.WriteLock cacheWriteLock = this.cacheLock.writeLock();
        cacheWriteLock.lock();
        int i = 0;
        for (Style<?, R> style : this.styles) {
            if (style.getType() != type || !style.isValid(this.cache)) continue;
            this.cache.put(style.getType(), style);
            ++i;
        }
        cacheWriteLock.unlock();
        return i;
    }

    public void addStyle(Style<?, R> style) {
        StyleType<?, R> type = style.getType();
        this.styles.add(style);
        if (this.cache.get(type) == style) {
            return;
        }
        ReentrantReadWriteLock.WriteLock cacheWriteLock = this.cacheLock.writeLock();
        if (style.isValid(this.cache)) {
            cacheWriteLock.lock();
            this.cache.put(style.getType(), style);
            cacheWriteLock.unlock();
        }
        this.setHasNewStyle();
    }

    public void removeStyle(Style<?, R> style) {
        StyleType<?, R> type = style.getType();
        if (this.cache.get(type) != style) {
            this.styles.remove(style);
        }
        this.styles.remove(style);
        ReentrantReadWriteLock.WriteLock cacheWriteLock = this.cacheLock.writeLock();
        cacheWriteLock.lock();
        int i = this.freshCache(type);
        if (i == 0) {
            this.cache.put(type, (Style<?, R>)type.getDefault());
        }
        this.cache.remove(type);
        cacheWriteLock.unlock();
        this.setHasNewStyle();
    }

    public String toString() {
        this.cacheLock.readLock().lock();
        StringBuilder sb = new StringBuilder();
        for (Style<?, R> style : this.styles) {
            if (!sb.isEmpty()) {
                sb.append(';');
            }
            sb.append(style.toString());
        }
        this.cacheLock.readLock().unlock();
        return sb.toString();
    }

    public void decode(String style) {
        this.cacheLock.writeLock().lock();
        Stack readStateStack = new Stack();
        StyleStates.PartState partState = StyleStates.PartState.ATTRIBUTE;
        StringBuilder current = new StringBuilder();
        String key = "";
        block5: for (int i = 0; i < style.length(); ++i) {
            char chr = style.charAt(i);
            switch (chr) {
                case '\\': {
                    if (partState == StyleStates.PartState.ATTRIBUTE) {
                        throw new IllegalStateException("ESCAPE CHARACTER \"\\\" IS NOT ALLOWED IN ATTRIBUTE AREA");
                    }
                    current.append(chr);
                    continue block5;
                }
                case ':': {
                    if (partState == StyleStates.PartState.ATTRIBUTE) {
                        partState = StyleStates.PartState.VALUE;
                    }
                    key = current.toString();
                    current = new StringBuilder();
                    continue block5;
                }
                case ';': {
                    if (partState != StyleStates.PartState.VALUE) continue block5;
                    StyleType<?, R> styleType = this.styleRegistry.getStyle(key);
                    if (styleType != null) {
                        this.addStyle((Style<?, R>)styleType.create(current.toString()));
                    }
                    key = "";
                    current = new StringBuilder();
                    continue block5;
                }
                default: {
                    current.append(chr);
                }
            }
        }
        this.cacheLock.writeLock().unlock();
    }

    public <T extends Style<?, R>> T get(StyleType<T, R> type) {
        return (T)this.cache.get(type);
    }

    public void clear() {
        this.cacheLock.writeLock().lock();
        this.styles.clear();
        this.cache.clear();
        this.styleUpdate.clear();
        this.cacheLock.writeLock().unlock();
        this.setHasNewStyle();
    }

    public boolean hasNewStyle(Object target) {
        return this.styleUpdate.getOrDefault(target, true);
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public void notifyUpdate() {
        this.setHasNewStyle();
    }

    public void resetNewStyle(Object target) {
        this.styleUpdate.put(target, false);
    }

    public Collection<Style<?, R>> getCachedStyles() {
        return this.cache.values();
    }

    public void forEachCacheStyle(Consumer<Style<?, R>> consumer) {
        this.cacheLock.readLock().lock();
        for (Style<?, R> value : this.cache.values()) {
            consumer.accept(value);
        }
        this.cacheLock.readLock().unlock();
    }

    private void setHasNewStyle() {
        this.styleUpdate.clear();
        if (this.callback != null) {
            this.callback.execute();
        }
    }

    @HostAccess.Export
    public void setStyle(String name, String value) {
        this.removeStyle(name);
        StyleType<?, R> type = this.styleRegistry.getStyle(name);
        if (type == null) {
            return;
        }
        this.addStyle((Style<?, R>)type.create(value));
    }

    @HostAccess.Export
    public void removeStyle(String name) {
        StyleType<?, R> type = this.styleRegistry.getStyle(name);
        if (type == null) {
            return;
        }
        Style<?, R> current = this.cache.get(type);
        while (current != null) {
            this.removeStyle(current);
            current = this.cache.get(type);
        }
    }
}

