/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.dom.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import kasuga.lib.core.javascript.engine.JavascriptValue;

public class EventEmitter {
    HashMap<String, Set<Consumer<Object[]>>> listeners = new HashMap();
    HashMap<String, Set<JavascriptValue>> functionalListeners = new HashMap();

    public UnsubscribeHandler subscribe(String eventName, Consumer<Object[]> consumer) {
        this.listeners.computeIfAbsent(eventName, v -> new HashSet()).add(consumer);
        return () -> this.unsubscribe(eventName, consumer);
    }

    public void unsubscribe(String eventName, Consumer<Object[]> consumer) {
        this.listeners.computeIfPresent(eventName, (name, data) -> {
            data.remove(consumer);
            return data.isEmpty() ? null : data;
        });
    }

    public void subscribe(String eventName, JavascriptValue consumer) {
        consumer = consumer.cloneValue();
        consumer.pin();
        this.functionalListeners.computeIfAbsent(eventName, v -> new HashSet()).add(consumer);
    }

    public void unsubscribe(String eventName, JavascriptValue consumer) {
        this.functionalListeners.computeIfPresent(eventName, (name, data) -> {
            for (JavascriptValue entryValue : data) {
                if (!consumer.equals(entryValue)) continue;
                data.remove(entryValue);
                entryValue.unpin();
                break;
            }
            return data.isEmpty() ? null : data;
        });
    }

    public void dispatchEvent(String eventName, Object ... event) {
        Set<Consumer<Object[]>> consumers = this.listeners.get(eventName);
        if (consumers != null) {
            ArrayList<Consumer<Object[]>> temporaryConsumer = new ArrayList<Consumer<Object[]>>(consumers);
            for (Consumer consumer : temporaryConsumer) {
                consumer.accept(event);
            }
        }
        if (this.functionalListeners.containsKey(eventName)) {
            ArrayList functionalConsumers = new ArrayList(this.functionalListeners.get(eventName));
            for (JavascriptValue javascriptValue : functionalConsumers) {
                javascriptValue.executeVoid(event);
            }
        }
    }

    public static interface UnsubscribeHandler {
        public void unsubscribe();
    }
}

