/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.frontend.common.layouting.LayoutBox;
import kasuga.lib.core.client.frontend.gui.GuiInstance;
import kasuga.lib.core.client.frontend.gui.SourceInfo;
import kasuga.lib.core.client.frontend.gui.events.mouse.MouseClickEvent;
import kasuga.lib.core.client.frontend.gui.events.mouse.MouseDownEvent;
import kasuga.lib.core.client.frontend.gui.events.mouse.MouseMoveEvent;
import kasuga.lib.core.client.frontend.gui.events.mouse.MouseUpEvent;
import kasuga.lib.core.client.frontend.gui.nodes.GuiDomRoot;
import kasuga.lib.core.client.frontend.rendering.RenderContext;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.core.util.data_type.Vec2i;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GuiScreen
extends Screen {
    private final GuiInstance instance;
    private final boolean autoClose;
    Pair<Double, Double> lastClickedPos = null;

    public GuiScreen(GuiInstance guiInstance) {
        super((Component)Component.m_237113_((String)""));
        this.instance = guiInstance;
        this.instance.open(this);
        this.autoClose = false;
    }

    public GuiScreen(ResourceLocation screenId) {
        super((Component)Component.m_237113_((String)""));
        this.instance = KasugaLib.STACKS.GUI.orElseThrow(IllegalStateException::new).create(screenId);
        this.instance.open(this);
        this.autoClose = true;
    }

    protected void m_7856_() {
        this.instance.updateSourceInfo((Object)this, new SourceInfo(new LayoutBox(0.0f, 0.0f, this.f_96543_, this.f_96544_)));
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.instance.beforeRender();
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.instance.getContext().ifPresent(context -> context.render((Object)this, RenderContext.fromScreen(this, pPoseStack, pMouseX, pMouseY, pPartialTick)));
        this.instance.afterRender();
    }

    public void m_7379_() {
        super.m_7379_();
        this.instance.close(this);
        if (this.autoClose) {
            KasugaLib.STACKS.GUI.orElseThrow(IllegalStateException::new).closeInstance(this.instance);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        MouseDownEvent event = MouseDownEvent.fromScreen(null, new Vec2i((int)pMouseX, (int)pMouseY), pButton);
        this.instance.getContext().ifPresent(context -> context.appendTask(() -> ((GuiDomRoot)context.getRootNode()).onMouseEvent((Object)this, event)));
        this.lastClickedPos = Pair.of(pMouseX, pMouseY);
        return true;
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        MouseUpEvent event = MouseUpEvent.fromScreen(null, new Vec2i((int)pMouseX, (int)pMouseY), pButton);
        this.instance.getContext().ifPresent(context -> context.appendTask(() -> ((GuiDomRoot)context.getRootNode()).onMouseEvent((Object)this, event)));
        if (this.lastClickedPos != null && Math.abs(this.lastClickedPos.getFirst() - pMouseX) + Math.abs(this.lastClickedPos.getSecond() - pMouseY) < 0.1) {
            MouseClickEvent clickEvent = MouseClickEvent.fromScreen(null, new Vec2i((int)pMouseX, (int)pMouseY), pButton);
            this.instance.getContext().ifPresent(context -> context.appendTask(() -> ((GuiDomRoot)context.getRootNode()).onMouseEvent((Object)this, clickEvent)));
        }
        this.lastClickedPos = null;
        return true;
    }

    public void m_94757_(double pMouseX, double pMouseY) {
        MouseMoveEvent moveEvent = MouseMoveEvent.fromScreen(null, new Vec2i((int)pMouseX, (int)pMouseY), 0);
        this.instance.getContext().ifPresent(context -> context.appendTask(() -> ((GuiDomRoot)context.getRootNode()).onMouseEvent((Object)this, moveEvent)));
    }

    public boolean m_7043_() {
        return false;
    }
}

