/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.canvas;

import com.mojang.blaze3d.vertex.VertexConsumer;
import kasuga.lib.core.client.frontend.gui.canvas.DrawTool;
import kasuga.lib.core.client.frontend.gui.canvas.Point2D;
import kasuga.lib.core.client.frontend.gui.canvas.glfw.CanvasRenderer;
import kasuga.lib.core.util.Callback;

public class CanvasRenderingContext2D {
    CanvasRenderer canvasRenderer;
    Point2D current = Point2D.ZERO;
    float lineWidth = 0.0f;

    public CanvasRenderingContext2D(CanvasRenderer renderer) {
        this.canvasRenderer = renderer;
    }

    public void moveTo(float x, float y) {
        this.current = new Point2D(x, y);
    }

    public void lineTo(float x, float y) {
        Point2D next = new Point2D(x, y);
        this.draw(() -> DrawTool.drawLine(this.current.x(), this.current.y(), next.x(), next.y(), this.lineWidth, this::strokeVertexProperty));
        this.current = next;
    }

    public void fillRect(float x, float y, float width, float height) {
        this.draw(() -> {
            DrawTool.drawRect(x, y, width, height, this::fillVertexProperty);
            DrawTool.drawLine(x, y, x + width, y, this.lineWidth, this::strokeVertexProperty);
            DrawTool.drawLine(x + width, y, x + width, y + height, this.lineWidth, this::strokeVertexProperty);
            DrawTool.drawLine(x + width, y + height, x, y + height, this.lineWidth, this::strokeVertexProperty);
            DrawTool.drawLine(x, y + height, x, y, this.lineWidth, this::strokeVertexProperty);
        });
    }

    public void clearRect(float x, float y, float width, float height) {
        this.draw(() -> DrawTool.drawRect(x, y, width, height, this::clearColorProperty));
    }

    private void draw(Callback drawFunction) {
        this.canvasRenderer.pushTask(drawFunction);
    }

    private void strokeVertexProperty(VertexConsumer consumer, Integer integer) {
        consumer.m_85950_(0.0f, 1.0f, 0.0f, 1.0f);
    }

    private void clearColorProperty(VertexConsumer consumer, Integer integer) {
        consumer.m_85950_(0.0f, 0.0f, 0.0f, 0.0f);
    }

    private void fillVertexProperty(VertexConsumer consumer, Integer integer) {
        consumer.m_85950_(1.0f, 0.0f, 0.0f, 1.0f);
    }
}

