/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.nodes;

import com.caoccao.javet.annotations.V8Convert;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.frontend.common.layouting.LayoutBox;
import kasuga.lib.core.client.frontend.common.layouting.LayoutContext;
import kasuga.lib.core.client.frontend.common.layouting.LayoutNode;
import kasuga.lib.core.client.frontend.common.style.StyleAttributeProxy;
import kasuga.lib.core.client.frontend.common.style.StyleList;
import kasuga.lib.core.client.frontend.common.style.StyleTarget;
import kasuga.lib.core.client.frontend.dom.nodes.DomNode;
import kasuga.lib.core.client.frontend.font.ExtendableProperty;
import kasuga.lib.core.client.frontend.gui.GuiContext;
import kasuga.lib.core.client.frontend.gui.events.mouse.MouseEvent;
import kasuga.lib.core.client.frontend.gui.layout.EdgeSize2D;
import kasuga.lib.core.client.frontend.rendering.BackgroundRenderer;
import kasuga.lib.core.client.frontend.rendering.RenderContext;
import kasuga.lib.core.javascript.engine.annotations.HostAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.common.util.Lazy;

@V8Convert
public class GuiDomNode
extends DomNode<GuiContext> {
    @HostAccess.Export
    public StyleList<StyleTarget> styles;
    public ExtendableProperty<Integer> fontSize;
    private Integer zIndex;
    Lazy<LayoutContext<?, GuiDomNode>> layoutManager;
    protected BackgroundRenderer background;

    protected void fontSizeUpdated() {
    }

    public GuiDomNode(GuiContext context) {
        super(context);
        this.styles = new StyleList<StyleTarget>(KasugaLib.STACKS.GUI.orElseThrow((Supplier<IllegalStateException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/IllegalStateException;)()).styleRegistry);
        this.fontSize = new ExtendableProperty<Integer>(() -> {
            Integer n;
            DomNode patt1562$temp = this.parent;
            if (patt1562$temp instanceof GuiDomNode) {
                GuiDomNode node = (GuiDomNode)patt1562$temp;
                n = node.fontSize.get();
            } else {
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                n = 9;
            }
            return n;
        }, () -> {
            this.children.forEach(c -> {
                if (c instanceof GuiDomNode) {
                    GuiDomNode child = (GuiDomNode)c;
                    child.fontSize.notifyUpdate();
                }
            });
            this.fontSizeUpdated();
        });
        this.zIndex = 0;
        this.layoutManager = Lazy.concurrentOf(() -> new LayoutContext(this, ((GuiContext)this.domContext).getLayoutEngine()));
        this.background = new BackgroundRenderer();
        this.attributes.registerProxy("style", new StyleAttributeProxy(this.styles));
        this.styles.setCallback(this::onStyleUpdate);
    }

    private void onStyleUpdate() {
        DomNode domNode;
        if (this.parent != null && (domNode = this.parent) instanceof GuiDomNode) {
            GuiDomNode parentNode = (GuiDomNode)domNode;
            parentNode.styles.notifyUpdate();
        }
    }

    public StyleList<StyleTarget> getStyle() {
        return this.styles;
    }

    public LayoutContext<?, GuiDomNode> getLayoutManager() {
        return (LayoutContext)this.layoutManager.get();
    }

    @Override
    @HostAccess.Export
    public boolean addChildBefore(DomNode<GuiContext> child, DomNode<GuiContext> before) {
        ((GuiContext)this.domContext).queueDuringRender(() -> {
            int index = this.children.indexOf(before);
            if (index == -1) {
                return;
            }
            this.addChildInstant(index, child);
        });
        return true;
    }

    @Override
    @HostAccess.Export
    public boolean addChildAt(int i, DomNode<GuiContext> child) {
        ((GuiContext)this.domContext).queueDuringRender(() -> this.addChildInstant(i, child));
        return true;
    }

    protected void addChildInstant(int i, DomNode<GuiContext> child) {
        if (child instanceof GuiDomNode) {
            GuiDomNode domNode = (GuiDomNode)child;
            this.getLayoutManager().addChild(i, domNode.getLayoutManager());
        }
        this.styles.notifyUpdate();
        super.addChildAt(i, child);
    }

    @Override
    @HostAccess.Export
    public boolean removeChild(DomNode<GuiContext> child) {
        ((GuiContext)this.domContext).queueDuringRender(() -> {
            boolean result = super.removeChild(child);
            if (child instanceof GuiDomNode) {
                GuiDomNode domNode = (GuiDomNode)child;
                this.getLayoutManager().removeChild(domNode.getLayoutManager());
            }
            this.styles.notifyUpdate();
            super.removeChild(child);
        });
        return this.children.contains(child);
    }

    @Override
    @HostAccess.Export
    public boolean addChild(DomNode<GuiContext> child) {
        ((GuiContext)this.domContext).queueDuringRender(() -> this.addChildInstant(this.children.size(), child));
        return true;
    }

    @Override
    public void render(Object source, RenderContext context) {
        this.renderNode(source, context);
    }

    public float renderNode(Object source, RenderContext context) {
        if (!this.getLayoutManager().hasSource(source)) {
            return 0.0f;
        }
        this.updateStyles();
        LayoutNode layout = this.getLayoutManager().getSourceNode(source);
        LayoutBox coordinate = layout.getPosition();
        this.background.render(context, coordinate.x, coordinate.y, coordinate.width, coordinate.height);
        EdgeSize2D border = layout.getBorder();
        MultiBufferSource bufferSource = context.getBufferSource();
        HashMap<Integer, ArrayList> childrenDepthMap = new HashMap<Integer, ArrayList>();
        for (DomNode child : this.children) {
            childrenDepthMap.computeIfAbsent(((GuiDomNode)child).zIndex, i -> new ArrayList()).add(child);
        }
        ArrayList zIndexList = new ArrayList(childrenDepthMap.keySet().stream().toList());
        zIndexList.sort(Integer::compareTo);
        float totalDepth = 0.003f;
        context.pose().m_85837_(0.0, 0.0, 0.003);
        for (Integer zIndex : zIndexList) {
            ArrayList zList = (ArrayList)childrenDepthMap.get(zIndex);
            float maxiumDepth = 0.0f;
            for (DomNode guiContextDomNode : zList) {
                maxiumDepth = Math.max(maxiumDepth, ((GuiDomNode)guiContextDomNode).renderNode(source, context));
            }
            context.pose().m_85837_(0.0, 0.0, (double)maxiumDepth + 0.003);
            totalDepth = (float)((double)totalDepth + ((double)maxiumDepth + 0.003));
        }
        return totalDepth;
    }

    private void updateStyles() {
        if (!this.styles.hasNewStyle(this)) {
            return;
        }
        this.styles.forEachCacheStyle(style -> ((StyleTarget)style.getTarget()).attemptApply(this));
        this.styles.resetNewStyle(this);
    }

    @Override
    public void close() {
        super.close();
        this.getLayoutManager().close();
    }

    @Override
    @HostAccess.Export
    public boolean hasFeature(String feature) {
        if (Objects.equals(feature, "style")) {
            return true;
        }
        return super.hasFeature(feature);
    }

    public BackgroundRenderer getBackgroundRenderer() {
        return this.background;
    }

    public boolean onMouseEvent(Object source, MouseEvent event) {
        LayoutContext<?, GuiDomNode> layout = this.getLayoutManager();
        if (!layout.hasSource(source)) {
            return false;
        }
        LayoutNode sourceNode = layout.getSourceNode(source);
        if (sourceNode == null) {
            return false;
        }
        LayoutBox box = sourceNode.getRelative();
        if (!box.contains(event.getOffsetPosition().x, event.getOffsetPosition().y)) {
            return false;
        }
        LayoutBox screen = sourceNode.getPosition();
        MouseEvent translated = event.forkChild(this, event.getScreenPosition().x - (int)screen.x, event.getScreenPosition().y - (int)screen.y);
        GuiDomNode target = this;
        for (DomNode child : this.children) {
            GuiDomNode domNode;
            if (!(child instanceof GuiDomNode) || !(domNode = (GuiDomNode)child).onMouseEvent(source, translated)) continue;
            target = domNode;
            break;
        }
        MouseEvent finalEvent = event.withTarget(target);
        if (!translated.isPropagationStopped()) {
            this.dispatchEvent(event.getType(), finalEvent);
        }
        return true;
    }

    public void setZIndex(Integer zIndex) {
        this.zIndex = zIndex;
    }
}

