/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.styles.node;

import java.util.Map;
import kasuga.lib.core.client.frontend.common.style.Style;
import kasuga.lib.core.client.frontend.common.style.StyleTarget;
import kasuga.lib.core.client.frontend.common.style.StyleType;
import kasuga.lib.core.client.frontend.gui.styles.node.SimpleNodeStyleType;
import kasuga.lib.core.client.render.SimpleColor;

public class BackgroundFilterColor
extends Style<SimpleColor, StyleTarget> {
    public static final StyleType<BackgroundFilterColor, StyleTarget> TYPE = SimpleNodeStyleType.of(BackgroundFilterColor::new, "");
    public static final BackgroundFilterColor EMPTY = new BackgroundFilterColor();
    protected final String value;
    protected final SimpleColor color;

    private BackgroundFilterColor() {
        this.value = "";
        this.color = SimpleColor.BLACK;
    }

    public BackgroundFilterColor(String value) {
        this.value = value;
        this.color = SimpleColor.fromHexString(value);
    }

    public BackgroundFilterColor(SimpleColor color) {
        this.value = color.toHexString();
        this.color = color;
    }

    @Override
    public boolean isValid(Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>> origin) {
        return true;
    }

    @Override
    public StyleType<?, StyleTarget> getType() {
        return TYPE;
    }

    @Override
    public StyleTarget getTarget() {
        return StyleTarget.GUI_DOM_NODE.create(node -> node.getBackgroundRenderer().setColor(this.color));
    }

    @Override
    public String getValueString() {
        return this.value;
    }

    @Override
    public SimpleColor getValue() {
        return this.color;
    }
}

