/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.rendering;

import com.mojang.math.Vector3f;
import kasuga.lib.core.client.frontend.rendering.ImageProvider;
import kasuga.lib.core.client.frontend.rendering.RenderContext;
import kasuga.lib.core.client.render.SimpleColor;
import kasuga.lib.core.client.render.texture.ImageMask;
import kasuga.lib.core.client.render.texture.NineSlicedImageMask;
import kasuga.lib.core.client.render.texture.StaticImage;
import kasuga.lib.core.util.LazyRecomputable;
import net.minecraft.resources.ResourceLocation;

public class BackgroundRenderer {
    public ResourceLocation location;
    public SimpleColor color = SimpleColor.fromRGBInt(0xFFFFFF);
    public float opacity = 1.0f;
    public float borderSize = 0.0f;
    public float borderScale = 1.0f;
    private ImageProvider image;
    int left = 0;
    int top = 0;
    int width = 0;
    int height = 0;
    public LazyRecomputable<ImageMask> mask = LazyRecomputable.of(() -> {
        if (this.image == null) {
            return null;
        }
        StaticImage sim = this.image.getImage();
        if (sim == null) {
            return null;
        }
        ImageMask mask = sim.getMask();
        float w = sim.image.getWidth();
        float h = sim.image.getHeight();
        mask.setColor(this.color);
        return mask.rectangleUV((float)this.left / w, (float)this.top / h, this.width == 0 ? 1.0f : (float)(this.width + this.left) / w, this.height == 0 ? 1.0f : (float)(this.height + this.top) / h);
    });
    public LazyRecomputable<NineSlicedImageMask> nineSlicedMask = LazyRecomputable.of(() -> {
        if (this.image == null) {
            return null;
        }
        StaticImage sim = this.image.getImage();
        if (sim == null) {
            return null;
        }
        NineSlicedImageMask mask = sim.getNineSlicedMask();
        float w = sim.image.getWidth();
        float h = sim.image.getHeight();
        mask.rectangleUV((float)this.left / w, (float)this.top / h, this.width == 0 ? 1.0f : (float)(this.width + this.left) / w, this.height == 0 ? 1.0f : (float)(this.height + this.top) / h);
        mask.setBordersDirectly(this.borderSize / (float)this.width, 1.0f - this.borderSize / (float)this.width, this.borderSize / (float)this.height, 1.0f - this.borderSize / (float)this.height);
        mask.setScalingFactor(this.borderScale);
        mask.setColor(this.color);
        return mask;
    });
    RenderMode mode = RenderMode.COMMON;

    public void setRenderMode(RenderMode mode) {
        this.mode = mode;
    }

    public void render(RenderContext context, float x, float y, float width, float height) {
        if (this.mode == RenderMode.COMMON) {
            this.neoRenderCommon(context, x, y, width, height);
        } else {
            this.neoRenderNineSliced(context, x, y, width, height);
        }
    }

    public void setNineSlicedParam(float borderSize, float borderScale) {
        this.borderSize = borderSize;
        this.borderScale = borderScale;
    }

    private void neoRenderNineSliced(RenderContext context, float x, float y, float width, float height) {
        if (this.mask == null) {
            return;
        }
        ImageMask imageMask = this.nineSlicedMask.get();
        imageMask.rectangle(new Vector3f(x, y, 0.0f), ImageMask.Axis.X, ImageMask.Axis.Y, true, true, width, height);
        if (context.getContextType() == RenderContext.RenderContextType.SCREEN) {
            imageMask.renderToGui(context.pose().m_85850_());
        } else {
            imageMask.renderToWorld(context.pose(), context.getBufferSource(), context.getRenderType().build(imageMask.image.id), false, context.packedLight);
        }
    }

    public void neoRenderCommon(RenderContext context, float x, float y, float width, float height) {
        if (this.mask == null) {
            return;
        }
        ImageMask imageMask = this.mask.get();
        if (imageMask == null) {
            return;
        }
        imageMask.rectangle(new Vector3f(x, y, 0.0f), ImageMask.Axis.X, ImageMask.Axis.Y, true, true, width, height);
        if (context.getContextType() == RenderContext.RenderContextType.SCREEN) {
            imageMask.renderToGui(context.pose().m_85850_());
        } else {
            imageMask.renderToWorld(context.pose(), context.getBufferSource(), context.getRenderType().build(imageMask.image.id), false, context.packedLight);
        }
    }

    public void markDirty() {
        this.mask.clear();
        this.nineSlicedMask.clear();
    }

    public void setImage(ImageProvider provider) {
        this.image = provider;
        this.markDirty();
    }

    public void setUV(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.markDirty();
    }

    public void setColor(SimpleColor color) {
        this.color = color;
        this.markDirty();
    }

    public static enum RenderMode {
        COMMON,
        NINE_SLICED;

    }
}

