/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.Stack;
import kasuga.lib.core.client.frontend.common.interaction.MouseContext;
import kasuga.lib.core.client.frontend.common.interaction.PlaneMouseContext;
import kasuga.lib.core.client.render.texture.old.WorldTexture;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;

public class RenderContext {
    protected RenderContextType contextType;
    protected MultiBufferSource bufferSource;
    protected PoseStack poseStack;
    protected MouseContext mouse = MouseContext.EMPTY;
    protected float partialTicks = 0.0f;
    protected int packedLight = 0xF000F0;
    protected Stack<Integer> lightStack = new Stack();
    protected int packedOverlay = OverlayTexture.f_118083_;
    protected WorldTexture.RenderTypeBuilder renderType = RenderType::m_110497_;
    protected int zStack;
    public static Object EMPTY_SOURCE = new Object();
    public Object source = EMPTY_SOURCE;
    float increment = 0.0f;

    public static RenderContext fromScreen(Screen screen, PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        RenderContext context = new RenderContext(RenderContextType.SCREEN);
        context.setPoseStack(pPoseStack);
        context.setMouseContext(new PlaneMouseContext(pMouseX, pMouseY));
        context.setPartialTicks(pPartialTick);
        context.setSource(screen);
        return context;
    }

    public WorldTexture.RenderTypeBuilder getRenderType() {
        return this.renderType;
    }

    public RenderContext(RenderContextType contextType) {
        this.contextType = contextType;
    }

    public MouseContext mouse() {
        return this.mouse;
    }

    public PoseStack pose() {
        return this.poseStack;
    }

    public Matrix4f poseMatrix() {
        return this.pose().m_85850_().m_85861_();
    }

    public void pushPose(PoseStack.Pose pose) {
        this.pushPose(pose.m_85861_());
    }

    public void pushPose(Matrix4f pose) {
        this.pushPose();
        this.pose().m_166854_(pose);
    }

    public void pushPose() {
        this.poseStack.m_85836_();
    }

    public void popPose() {
        this.poseStack.m_85849_();
    }

    public void pushLight(int light) {
        this.lightStack.push(light);
        this.packedLight = light;
    }

    public void popLight() {
        this.lightStack.pop();
        this.packedLight = this.lightStack.isEmpty() ? 0 : this.lightStack.peek();
    }

    public MultiBufferSource getBufferSource() {
        return this.bufferSource;
    }

    public void setBufferSource(MultiBufferSource bufferSource) {
        this.bufferSource = bufferSource;
    }

    public void pushZStack() {
        ++this.zStack;
        this.poseStack.m_85837_(0.0, 0.0, -1.0);
    }

    public void popZStack() {
        --this.zStack;
        this.poseStack.m_85837_(0.0, 0.0, 1.0);
    }

    public void setPoseStack(PoseStack pPoseStack) {
        this.poseStack = pPoseStack;
    }

    public void setPartialTicks(float partialTicks) {
        this.partialTicks = partialTicks;
    }

    public void setMouseContext(MouseContext mouse) {
        this.mouse = mouse;
    }

    public RenderContextType getContextType() {
        return this.contextType;
    }

    public int getLight() {
        return this.packedLight;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public void addIncrement(float increment) {
        this.increment += increment;
    }

    public float getIncrement() {
        return this.increment;
    }

    public float getAndClearIncrement() {
        float _inc = this.increment;
        this.increment = 0.0f;
        return _inc;
    }

    public static enum RenderContextType {
        WORLD,
        SCREEN;

    }
}

