/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import javax.annotation.Nullable;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.model.BedrockModelLoader;
import kasuga.lib.core.client.model.ItemTransformProvider;
import kasuga.lib.core.client.model.anim_model.AnimModel;
import kasuga.lib.core.client.model.model_json.BedrockModel;
import kasuga.lib.core.client.model.model_json.Geometry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.client.model.geometry.IGeometryLoader;

public class AnimModelLoader
implements IGeometryLoader<AnimModel>,
ResourceManagerReloadListener,
ItemTransformProvider {
    private ResourceManager manager;
    private final HashMap<ResourceLocation, AnimModel> MODELS = new HashMap();
    public static final AnimModelLoader INSTANCE = new AnimModelLoader();

    private AnimModelLoader() {
    }

    public void m_6213_(ResourceManager pResourceManager) {
        this.manager = pResourceManager;
    }

    public AnimModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
        BedrockModel model = BedrockModelLoader.readModel(jsonObject, deserializationContext);
        if (model == null) {
            return null;
        }
        ResourceLocation renderTypeHint = jsonObject.has("render_type") ? new ResourceLocation(jsonObject.get("render_type").getAsString()) : new ResourceLocation("solid");
        String geometry = jsonObject.get("geometry").getAsString();
        Geometry geo = null;
        for (Geometry g : model.getGeometries()) {
            if (!g.getDescription().getIdentifier().equals(geometry)) continue;
            geo = g;
            break;
        }
        if (geo == null) {
            return null;
        }
        AnimModel animModel = new AnimModel(geo, model.getMaterials(), renderTypeHint);
        if (jsonObject.has("identifier")) {
            ResourceLocation identifier = new ResourceLocation(jsonObject.get("identifier").getAsString());
            if (this.MODELS.containsKey(identifier)) {
                KasugaLib.MAIN_LOGGER.warn("Anim Model: " + identifier + " already exists, COVERED!");
            }
            this.MODELS.put(identifier, animModel);
        } else {
            KasugaLib.MAIN_LOGGER.warn("Anim Model: " + model.modelLocation + " has no identifier, and it WOULD NOT BE ABLE TO USE IN RENDERERS!");
        }
        return animModel;
    }

    @Nullable
    public AnimModel getModel(ResourceLocation location) {
        AnimModel model = this.MODELS.get(location);
        if (model == null) {
            return null;
        }
        model.init();
        return model;
    }
}

