/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import kasuga.lib.core.client.model.ItemTransformProvider;
import kasuga.lib.core.client.model.anim_model.AnimModel;
import kasuga.lib.core.client.model.model_json.BedrockModel;
import kasuga.lib.core.client.model.model_json.Geometry;
import kasuga.lib.core.util.LazyRecomputable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.geometry.IGeometryLoader;

@OnlyIn(value=Dist.CLIENT)
public class BedrockModelLoader
implements IGeometryLoader<BedrockModel>,
ResourceManagerReloadListener,
ItemTransformProvider {
    public static BedrockModelLoader INSTANCE = new BedrockModelLoader();
    private ResourceManager manager;
    public static final HashMap<ResourceLocation, BedrockModel> MODELS = new HashMap();
    public static final ResourceLocation MISSING_MODEL_LOCATION = new ResourceLocation("kasuga_lib", "default/missing_model");
    private static final LazyRecomputable<BedrockModel> MISSING = new LazyRecomputable<BedrockModel>(() -> MODELS.get(MISSING_MODEL_LOCATION));

    public void m_6213_(ResourceManager resourceManager) {
        this.manager = resourceManager;
    }

    public BedrockModel read(JsonObject jsonObject, @Nullable JsonDeserializationContext deserializationContext) throws JsonParseException {
        return BedrockModelLoader.readModel(jsonObject, deserializationContext);
    }

    public static BedrockModel readModel(JsonObject jsonObject, @Nullable JsonDeserializationContext context) {
        ResourceLocation ml = new ResourceLocation(jsonObject.get("model").getAsString());
        boolean flipV = jsonObject.has("flip_v") && jsonObject.get("flip_v").getAsBoolean();
        ArrayList<Material> materials = new ArrayList<Material>();
        Material texture = null;
        if (jsonObject.has("textures") && jsonObject.get("textures").isJsonObject()) {
            for (Map.Entry entry : jsonObject.get("textures").getAsJsonObject().entrySet()) {
                if (!((JsonElement)entry.getValue()).isJsonPrimitive() || ((String)entry.getKey()).equals("particle")) continue;
                Material mat = new Material(TextureAtlas.f_118259_, new ResourceLocation(((JsonElement)entry.getValue()).getAsString()));
                materials.add(mat);
                if (!((String)entry.getKey()).equals("texture")) continue;
                texture = mat;
            }
        } else {
            texture = new Material(TextureAtlas.f_118259_, new ResourceLocation(jsonObject.get("texture").getAsString()));
            materials.add(texture);
        }
        if (texture == null) {
            return null;
        }
        BedrockModel model = new BedrockModel(new ResourceLocation(ml.m_135827_(), "models/" + ml.m_135815_() + ".geo.json"), flipV, texture, materials);
        if (jsonObject.has("identifier")) {
            ResourceLocation identifier = new ResourceLocation(jsonObject.get("identifier").getAsString());
            MODELS.put(identifier, model);
        }
        return model;
    }

    public static List<AnimModel> getModels(ResourceLocation location, RenderType type) {
        BedrockModel unbaked = MODELS.getOrDefault(location, null);
        if (unbaked == null) {
            return List.of();
        }
        List<Geometry> geometry = unbaked.getGeometries();
        ArrayList<AnimModel> result = new ArrayList<AnimModel>(geometry.size());
        geometry.forEach(g -> result.add(g.getAnimationModel(type)));
        return result;
    }

    public static AnimModel getModel(ResourceLocation location, RenderType type) {
        BedrockModel unbaked = MODELS.getOrDefault(location, null);
        if (unbaked == null) {
            return null;
        }
        List<Geometry> geometries = unbaked.getGeometries();
        if (geometries.isEmpty()) {
            return null;
        }
        Geometry geometry = geometries.get(0);
        return geometry.getAnimationModel(type);
    }
}

