/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemTransformMapping {
    public static final HashMap<String, ItemTransforms.TransformType> TYPES = new HashMap();

    @Nullable
    public static ItemTransforms.TransformType getType(String string) {
        return TYPES.getOrDefault(string, null);
    }

    @Nullable
    public static String getName(ItemTransforms.TransformType type) {
        for (Map.Entry<String, ItemTransforms.TransformType> t : TYPES.entrySet()) {
            if (t.getValue() != type) continue;
            return t.getKey();
        }
        return null;
    }

    static {
        TYPES.put("none", ItemTransforms.TransformType.NONE);
        TYPES.put("thirdperson_lefthand", ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
        TYPES.put("thirdperson_righthand", ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        TYPES.put("firstperson_lefthand", ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND);
        TYPES.put("firstperson_righthand", ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        TYPES.put("head", ItemTransforms.TransformType.HEAD);
        TYPES.put("gui", ItemTransforms.TransformType.GUI);
        TYPES.put("ground", ItemTransforms.TransformType.GROUND);
        TYPES.put("fixed", ItemTransforms.TransformType.FIXED);
    }
}

