/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.annotation.Nullable;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.model.model_json.Geometry;
import kasuga.lib.core.util.Resources;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface ItemTransformProvider {
    @Nullable
    default public HashMap<ItemTransforms.TransformType, ItemTransform> generate(JsonObject jsonObject, Type type, JsonDeserializationContext context) {
        JsonArray geoJson;
        ResourceLocation ml = new ResourceLocation(jsonObject.get("model").getAsString());
        try {
            Resource resource = Resources.getResource(new ResourceLocation(ml.m_135827_(), "models/" + ml.m_135815_() + ".geo.json"));
            JsonObject geo = JsonParser.parseReader((Reader)resource.m_215508_()).getAsJsonObject();
            geoJson = geo.getAsJsonArray("minecraft:geometry");
        }
        catch (IOException e) {
            KasugaLib.MAIN_LOGGER.error("Failed to read Model: ", (Throwable)e);
            return null;
        }
        if (geoJson == null) {
            KasugaLib.MAIN_LOGGER.error("Failed to parse Model: " + ml);
            return null;
        }
        HashMap result = Maps.newHashMap();
        for (JsonElement geometry : geoJson.getAsJsonArray()) {
            result.putAll(Geometry.parseTransforms(geometry.getAsJsonObject()));
        }
        return result;
    }
}

