/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.model.anim_json.AnimationFile;
import kasuga.lib.core.util.Resources;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModelPreloadManager {
    public static final ModelPreloadManager INSTANCE = new ModelPreloadManager();
    public static final String PRELOAD_FILE = "anim_model_preload.json";
    private final List<ResourceLocation> modelPreloaded = new ArrayList<ResourceLocation>();
    private final List<ResourceLocation> animPreloaded = new ArrayList<ResourceLocation>();

    public void scan() {
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        Set namespaces = manager.m_7187_();
        HashMap<String, JsonObject> objs = new HashMap<String, JsonObject>();
        namespaces.forEach(name -> {
            ResourceLocation loc = new ResourceLocation(name, PRELOAD_FILE);
            Optional<Resource> resource = Resources.attemptGetResource(loc);
            if (resource.isEmpty()) {
                return;
            }
            Resource r = resource.get();
            try {
                JsonElement element = JsonParser.parseReader((Reader)r.m_215508_());
                if (element.isJsonObject()) {
                    objs.put((String)name, element.getAsJsonObject());
                }
            }
            catch (IOException e) {
                KasugaLib.MAIN_LOGGER.error("Failed to parse ANIM_MODEL_PRELOAD file " + loc, (Throwable)e);
            }
        });
        objs.forEach((name, obj) -> {
            Object str;
            String str2;
            JsonElement element;
            if (obj.has("model")) {
                element = obj.get("model");
                if (element.isJsonArray()) {
                    for (JsonElement e : element.getAsJsonArray()) {
                        str2 = e.getAsString();
                        this.modelPreloaded.add(new ResourceLocation(str2));
                    }
                } else if (element.isJsonPrimitive()) {
                    str = element.getAsString();
                    this.modelPreloaded.add(new ResourceLocation((String)str));
                }
            }
            if (obj.has("animation")) {
                element = obj.get("animation");
                if (element.isJsonArray()) {
                    for (JsonElement e : element.getAsJsonArray()) {
                        str2 = e.getAsString();
                        ResourceLocation rl = new ResourceLocation(str2);
                        this.animPreloaded.add(new ResourceLocation(rl.m_135827_(), "animations/" + rl.m_135815_() + ".animation.json"));
                    }
                } else if (element.isJsonPrimitive()) {
                    str = element.getAsString();
                    ResourceLocation rl = new ResourceLocation((String)str);
                    this.animPreloaded.add(new ResourceLocation(rl.m_135827_(), "animations/" + rl.m_135815_() + ".animation.json"));
                }
            }
        });
    }

    public void applyAnimPreload() {
        AnimationFile.UNREGISTERED.addAll(this.animPreloaded);
    }

    @SubscribeEvent
    public void registerPreloadedModel(ModelEvent.RegisterAdditional event) {
        this.modelPreloaded.forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
    }
}

