/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.anim_instance;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import kasuga.lib.KasugaLib;
import kasuga.lib.KasugaLibConfig;
import kasuga.lib.core.annos.Beta;
import kasuga.lib.core.client.model.anim_instance.AnimationInstance;
import kasuga.lib.core.client.model.anim_json.Animation;
import kasuga.lib.core.client.model.anim_model.AnimModel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@Beta
public class AnimCacheManager {
    public static final String PATH = "kasuga/anim_cache/";
    public static final AnimCacheManager INSTANCE = new AnimCacheManager();
    private final HashMap<String, byte[]> cache = Maps.newHashMap();

    public AnimCacheManager() {
        File file = new File(PATH);
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new RuntimeException("Falied to create kasuga lib cache file kasuga/anim_cache/");
        }
    }

    public boolean save(AnimationInstance instance) throws IOException {
        boolean bl;
        if (!AnimCacheManager.systemEnabled()) {
            return true;
        }
        File file = new File(PATH + AnimCacheManager.getPureFileName(instance).replace("/", "{%20}").replace(":", "{%05}"));
        if (!file.exists() && !file.createNewFile()) {
            return false;
        }
        boolean flag = instance.writeToFile(file);
        if (!flag) {
            return false;
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            this.cache.put(AnimCacheManager.getPureFileName(instance), fis.readAllBytes());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                KasugaLib.MAIN_LOGGER.error("Failed to open cache file: " + AnimCacheManager.getPureFileName(instance));
                return false;
            }
        }
        fis.close();
        return bl;
    }

    public boolean load(String pureFileName) {
        boolean bl;
        if (!AnimCacheManager.systemEnabled()) {
            return true;
        }
        File file = new File(PATH + pureFileName.replace("/", "{%20}").replace(":", "{%05}"));
        if (!file.isFile()) {
            return false;
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] b = fis.readAllBytes();
            this.cache.put(pureFileName, b);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                KasugaLib.MAIN_LOGGER.error("Failed to open cache file: " + pureFileName);
                return false;
            }
        }
        fis.close();
        return bl;
    }

    public void scanFolder() {
        if (!AnimCacheManager.systemEnabled()) {
            return;
        }
        File file = new File(PATH);
        if (!file.isDirectory()) {
            return;
        }
        int counter = 0;
        for (File f : Objects.requireNonNull(file.listFiles())) {
            if (!f.isFile() || !f.getName().endsWith(".anim_cache") || !this.load(f.getName().replace("{%05}", ":").replace("{%20}", "/"))) continue;
            ++counter;
        }
        KasugaLib.MAIN_LOGGER.info("Successfully loaded " + counter + " cache files.");
    }

    public static String getPureFileName(AnimationInstance instance) {
        return instance.animation.file.location + ":" + instance.animation.name + "-" + instance.model.geometry.getModel().modelLocation + ":" + instance.model.geometry.getDescription().getIdentifier() + "-" + instance.frameRate + ".anim_cache";
    }

    public static String getPureFileName(Animation instance, AnimModel model, int frameRate) {
        return instance.file.location + ":" + instance.name + "-" + model.geometry.getModel().modelLocation + ":" + model.geometry.getDescription().getIdentifier() + "-" + frameRate + ".anim_cache";
    }

    public boolean hasCache(String key) {
        return this.cache.containsKey(key);
    }

    public boolean hasCache(AnimationInstance instance) {
        return this.hasCache(AnimCacheManager.getPureFileName(instance));
    }

    public boolean hasCache(Animation animation, AnimModel model, int frameRate) {
        return this.hasCache(AnimCacheManager.getPureFileName(animation, model, frameRate));
    }

    public byte[] getCache(String key) {
        return this.cache.getOrDefault(key, new byte[0]);
    }

    public byte[] getCache(Animation animation, AnimModel model, int frameRate) {
        return this.cache.getOrDefault(AnimCacheManager.getPureFileName(animation, model, frameRate), new byte[0]);
    }

    public static boolean systemEnabled() {
        return KasugaLibConfig.CONFIG.getBoolValue("enable_animation_cache");
    }

    public void clearFolder() {
        File file = new File(PATH);
        if (!file.isDirectory()) {
            return;
        }
        for (File f : Objects.requireNonNull(file.listFiles())) {
            f.deleteOnExit();
        }
    }

    public void clearCaches() {
        this.cache.clear();
    }

    public void clearCachesAndFolder() {
        this.clearCaches();
        this.clearFolder();
    }
}

