/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.anim_instance;

import com.mojang.blaze3d.vertex.PoseStack;
import kasuga.lib.core.client.model.AnimModelLoader;
import kasuga.lib.core.client.model.anim_instance.AnimateTickerManager;
import kasuga.lib.core.client.model.anim_instance.AnimationInstance;
import kasuga.lib.core.client.model.anim_instance.Ticker;
import kasuga.lib.core.client.model.anim_json.Animation;
import kasuga.lib.core.client.model.anim_json.AnimationFile;
import kasuga.lib.core.client.model.anim_model.AnimModel;
import kasuga.lib.core.util.LazyRecomputable;
import lombok.Generated;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnimateTicker
implements Ticker {
    private float playSpeed;
    public final AnimationInstance animation;
    public final TickerType type;
    private float recent;
    private int starterTick;
    private int tick;
    private int endTick;
    private boolean moving;
    private boolean paused;

    public AnimateTicker(AnimationInstance instance, TickerType type, float playSpeed) {
        this.playSpeed = playSpeed;
        this.animation = instance;
        this.type = type;
        this.submit();
    }

    @Override
    public void submit() {
        AnimateTickerManager.INSTANCE.putTickerIn(this);
    }

    @Override
    public void unload() {
        AnimateTickerManager.INSTANCE.removeTicker(this);
    }

    @Override
    public TickerType getType() {
        return this.type;
    }

    public void setTick(int tick) {
        this.tick = tick;
    }

    public void setStarterTick(int tick) {
        this.starterTick = tick;
        this.recent = 0.0f;
        this.endTick = this.getEndTick();
    }

    public void setPlaySpeed(float speed) {
        this.playSpeed = speed;
        this.endTick = this.getEndTick();
    }

    public int getEndTick() {
        return (int)Math.ceil((double)this.starterTick + (double)(this.animation.length * 20.0f * 100.0f / Math.abs(this.playSpeed)));
    }

    public int getTick() {
        return this.tick;
    }

    public void start() {
        if (!this.paused) {
            this.setStarterTick(AnimateTickerManager.INSTANCE.getTick(this.type));
            this.recent = 0.0f;
            this.moving = true;
            this.tick = this.starterTick;
        } else {
            int t = AnimateTickerManager.INSTANCE.getTick(this.type);
            this.setStarterTick(t - this.tick);
            this.moving = true;
            this.paused = false;
            this.tick = t;
        }
    }

    public void stop() {
        this.moving = false;
        this.paused = false;
    }

    public void pause() {
        this.paused = true;
        this.moving = false;
    }

    public float tickToSec(float partial) {
        float offset = (float)this.tick - (float)this.starterTick + partial;
        float percentage = offset / (float)(this.endTick - this.starterTick);
        float result = percentage * this.animation.length;
        if (this.playSpeed < 0.0f) {
            result = this.animation.length - result;
        }
        this.recent = result;
        return result;
    }

    public void tickAndRender(PoseStack pose, MultiBufferSource source, int light, int overlay, float partial) {
        float sec = this.moving ? this.tickToSec(partial) : this.recent;
        this.animation.applyAndRender(pose, source, light, overlay, sec);
    }

    @Override
    public void tick(int tick) {
        if (!this.moving) {
            return;
        }
        this.tick = tick;
        if (tick >= this.endTick) {
            switch (this.animation.loop) {
                case LOOP: {
                    this.tick = this.starterTick;
                    break;
                }
                case NONE: {
                    this.tick = this.starterTick;
                    this.stop();
                    break;
                }
                case HOLD_ON_LAST_FRAME: {
                    this.stop();
                }
            }
        }
        this.tickToSec(0.0f);
    }

    public static LazyRecomputable<AnimateTicker> getTickerInstance(ResourceLocation modelLoc, ResourceLocation animFile, String animName, TickerType ticker, int frameRate, float playSpeed) {
        return new LazyRecomputable<AnimateTicker>(() -> {
            AnimationFile file;
            AnimModel model = AnimModelLoader.INSTANCE.getModel(modelLoc);
            if (model == null) {
                return null;
            }
            if (!model.isValidForRender()) {
                model.init();
            }
            if ((file = AnimationFile.fromFile(animFile).get()) == null) {
                return null;
            }
            Animation anim = file.getAnimation(animName);
            if (anim == null) {
                return null;
            }
            AnimationInstance instance = anim.getInstance(model, frameRate);
            return new AnimateTicker(instance, ticker, playSpeed);
        });
    }

    @Generated
    public float getPlaySpeed() {
        return this.playSpeed;
    }

    @Generated
    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    @Generated
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Generated
    public boolean isMoving() {
        return this.moving;
    }

    @Generated
    public boolean isPaused() {
        return this.paused;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum TickerType {
        RENDER,
        LOGICAL;

    }
}

