/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.anim_instance;

import java.util.HashSet;
import kasuga.lib.core.client.model.anim_instance.AnimateTicker;
import kasuga.lib.core.client.model.anim_instance.Ticker;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnimateTickerManager {
    public static final AnimateTickerManager INSTANCE = new AnimateTickerManager();
    private final HashSet<Ticker> GUI_TICKER = new HashSet();
    private final HashSet<Ticker> WORLD_TICKER = new HashSet();
    private int guiTick = 0;
    private int worldTick = 0;

    protected void putTickerIn(Ticker ticker) {
        if (ticker.getType() == AnimateTicker.TickerType.RENDER) {
            this.putGuiTickerIn(ticker);
        } else {
            this.putWorldTickerIn(ticker);
        }
    }

    protected void putGuiTickerIn(Ticker ticker) {
        this.GUI_TICKER.add(ticker);
    }

    protected void putWorldTickerIn(Ticker ticker) {
        this.WORLD_TICKER.add(ticker);
    }

    public void tickGui() {
        this.GUI_TICKER.forEach(t -> t.tick(this.guiTick));
        ++this.guiTick;
    }

    public void tickWorld() {
        this.WORLD_TICKER.forEach(t -> t.tick(this.worldTick));
        ++this.worldTick;
    }

    public int getGuiTick() {
        return this.guiTick;
    }

    public int getWorldTick() {
        return this.worldTick;
    }

    public int getTick(AnimateTicker.TickerType type) {
        return type == AnimateTicker.TickerType.RENDER ? this.getGuiTick() : this.getWorldTick();
    }

    public void removeTicker(Ticker ticker) {
        if (ticker.getType() == AnimateTicker.TickerType.RENDER) {
            this.GUI_TICKER.remove(ticker);
        } else {
            this.WORLD_TICKER.remove(ticker);
        }
    }

    public void resetTicks() {
        this.guiTick = 0;
        this.worldTick = 0;
    }

    public static AnimateTickerManager instance() {
        return INSTANCE;
    }
}

