/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.anim_instance;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.model.BedrockRenderable;
import kasuga.lib.core.client.model.anim_instance.InstanceOf;
import kasuga.lib.core.client.model.anim_instance.KeyFrameInstance;
import kasuga.lib.core.client.model.anim_json.Animation;
import kasuga.lib.core.client.model.anim_json.KeyFrame;
import kasuga.lib.core.client.model.anim_json.LoopMode;
import kasuga.lib.core.client.model.anim_model.AnimBone;
import kasuga.lib.core.client.model.anim_model.AnimModel;
import kasuga.lib.vendor_modules.org.apache.commons.lang3.tuple.Triple;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@InstanceOf(value=Animation.class)
public class AnimationInstance {
    public final AnimModel model;
    public final Animation animation;
    public final float length;
    public final LoopMode loop;
    public final int frameRate;
    private final int stepCount;
    private final float step;
    private final HashMap<String, AnimBone> bones;
    private final HashMap<String, KeyFrameInstance> frames;
    public static final int VERSION = -1766176;

    public AnimationInstance(Animation animation, AnimModel model, int frameRate) {
        this.animation = animation;
        this.model = model;
        this.frameRate = frameRate;
        this.length = animation.getAnimationLength();
        this.loop = animation.getLoop();
        this.stepCount = this.length <= 0.0f ? 1 : (int)Math.ceil(this.length * (float)frameRate);
        this.step = this.length / (float)this.stepCount;
        this.bones = new HashMap();
        this.frames = new HashMap();
        if (this.verify()) {
            this.compile();
        }
    }

    public AnimationInstance(AnimModel animModel, Animation animation, ByteArrayInputStream stream) throws IOException {
        String geometryName;
        String modelLoc;
        String animName;
        int version = AnimationInstance.read4Bytes(stream);
        if (version != -1766176) {
            throw new IOException("Invalid version number: " + version);
        }
        this.animation = animation;
        this.model = animModel;
        int aibLength = AnimationInstance.read4Bytes(stream);
        int fileLocLength = AnimationInstance.read4Bytes(stream);
        String animIdentifier = new String(stream.readNBytes(aibLength), StandardCharsets.UTF_8);
        int mibLength = AnimationInstance.read4Bytes(stream);
        int modelLocLength = AnimationInstance.read4Bytes(stream);
        String modelIdentifier = new String(stream.readNBytes(mibLength), StandardCharsets.UTF_8);
        String fileLoc = animIdentifier.substring(0, fileLocLength);
        if (!this.verifyFileName(fileLoc, animName = animIdentifier.substring(fileLocLength + 1), modelLoc = modelIdentifier.substring(0, modelLocLength), geometryName = modelIdentifier.substring(modelLocLength + 1))) {
            StringBuilder builder = new StringBuilder("Incompatible files: \n").append("Recent files: ").append(fileLoc).append(" -> ").append(animName).append(" & ").append(modelLoc).append(" -> ").append(geometryName).append("Needed: ").append(animation.file.location).append(" -> ").append(animation.name).append(" & ").append(this.model.geometry.getModel().modelLocation).append(" -> ").append(this.model.geometry.getDescription().getIdentifier()).append(".\nPlease check your files.");
            throw new IOException(builder.toString());
        }
        this.length = Float.intBitsToFloat(AnimationInstance.read4Bytes(stream));
        this.frameRate = AnimationInstance.read4Bytes(stream);
        this.step = Float.intBitsToFloat(AnimationInstance.read4Bytes(stream));
        this.stepCount = Float.floatToRawIntBits(AnimationInstance.read4Bytes(stream));
        this.loop = LoopMode.fromIndex(stream.read());
        int boneSize = AnimationInstance.read4Bytes(stream);
        this.bones = new HashMap();
        for (int i = 0; i < boneSize; ++i) {
            int x = AnimationInstance.read4Bytes(stream);
            byte[] b = stream.readNBytes(x);
            String bone = new String(b, StandardCharsets.UTF_8);
            BedrockRenderable renderable = this.model.getChild(bone);
            if (!(renderable instanceof AnimBone)) continue;
            AnimBone ab = (AnimBone)renderable;
            this.bones.put(bone, ab);
        }
        int frameSize = AnimationInstance.read4Bytes(stream);
        this.frames = new HashMap();
        for (int i = 0; i < frameSize; ++i) {
            KeyFrameInstance kfi = new KeyFrameInstance(this, stream);
            this.frames.put(kfi.keyFrame.bone, kfi);
        }
    }

    public boolean verify() {
        Map<String, BedrockRenderable> bones = this.model.children;
        HashSet<String> animKeyFrameSet = new HashSet<String>(this.animation.getFrames().keySet());
        for (Map.Entry<String, BedrockRenderable> entry : bones.entrySet()) {
            BedrockRenderable bedrockRenderable = entry.getValue();
            if (!(bedrockRenderable instanceof AnimBone)) continue;
            AnimBone bone = (AnimBone)bedrockRenderable;
            animKeyFrameSet.remove(entry.getKey());
            this.bones.put(entry.getKey(), bone);
        }
        boolean flag = animKeyFrameSet.isEmpty();
        if (!flag) {
            this.bones.clear();
        }
        return flag;
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public float getStep() {
        return this.step;
    }

    public void compile() {
        this.animation.getFrames().forEach((name, frame) -> {
            KeyFrameInstance kfi = new KeyFrameInstance((KeyFrame)frame, this.bones.get(name), this);
            if (kfi.canBeRemoved()) {
                return;
            }
            this.frames.put((String)name, kfi);
        });
    }

    public void applyAndRender(PoseStack pose, MultiBufferSource buffer, int light, int overlay, float sec) {
        this.frames.forEach((name, frame) -> frame.applyToBone(sec));
        this.model.render(pose, buffer, light, overlay);
    }

    public void mergeAnimation(HashMap<String, Triple<Vector3f, Vector3f, Vector3f>> vectors, float sec) {
        this.frames.forEach((name, frame) -> {
            Triple<Vector3f, Vector3f, Vector3f> v = frame.getVectors(sec);
            Triple cached = vectors.getOrDefault(name, null);
            if (cached == null) {
                vectors.put((String)name, v);
                return;
            }
            ((Vector3f)cached.getLeft()).m_122253_((Vector3f)v.getLeft());
            ((Vector3f)cached.getMiddle()).m_122253_((Vector3f)v.getMiddle());
            ((Vector3f)cached.getRight()).m_122263_(((Vector3f)v.getRight()).m_122239_(), ((Vector3f)v.getRight()).m_122260_(), ((Vector3f)v.getRight()).m_122269_());
        });
    }

    public void writeToCache(ByteArrayOutputStream stream) throws IOException {
        String animIdentifier = this.animation.file.location.toString() + ":" + this.animation.name;
        String modelIdentifier = this.model.geometry.getModel().modelLocation + ":" + this.model.geometry.getDescription().getIdentifier();
        AnimationInstance.write4Bytes(-1766176, stream);
        byte[] aib = animIdentifier.getBytes(StandardCharsets.UTF_8);
        byte[] mib = modelIdentifier.getBytes(StandardCharsets.UTF_8);
        AnimationInstance.write4Bytes(aib.length, stream);
        AnimationInstance.write4Bytes(this.animation.file.location.toString().length(), stream);
        stream.write(aib);
        AnimationInstance.write4Bytes(mib.length, stream);
        AnimationInstance.write4Bytes(this.model.geometry.getModel().modelLocation.toString().length(), stream);
        stream.write(mib);
        AnimationInstance.write4Bytes(Float.floatToIntBits(this.length), stream);
        AnimationInstance.write4Bytes(this.frameRate, stream);
        AnimationInstance.write4Bytes(Float.floatToIntBits(this.step), stream);
        AnimationInstance.write4Bytes(Float.floatToIntBits(this.stepCount), stream);
        stream.write(this.loop.getIndex());
        AnimationInstance.write4Bytes(this.bones.size(), stream);
        for (String key : this.bones.keySet()) {
            byte[] b = key.getBytes(StandardCharsets.UTF_8);
            AnimationInstance.write4Bytes(b.length, stream);
            stream.write(b);
        }
        AnimationInstance.write4Bytes(this.frames.size(), stream);
        for (KeyFrameInstance frame : this.frames.values()) {
            frame.writeToCache(stream);
        }
    }

    public boolean writeToFile(File file) {
        try {
            if (!file.isFile() && !file.createNewFile()) {
                KasugaLib.MAIN_LOGGER.error("Failed to save animation " + this.animation.name + " to file " + file.getPath() + ", could not create that file.");
                return false;
            }
            try (FileOutputStream stream = new FileOutputStream(file);){
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.writeToCache(baos);
                baos.writeTo(stream);
                baos.flush();
                stream.flush();
                baos.close();
            }
            return true;
        }
        catch (IOException e) {
            KasugaLib.MAIN_LOGGER.error("Encountered error while write anim cache to file " + file, (Throwable)e);
            return false;
        }
    }

    private boolean verifyFileName(String fileLoc, String animName, String modelLoc, String geometryName) {
        return fileLoc.equals(this.animation.file.location.toString()) && animName.equals(this.animation.name) && modelLoc.equals(this.model.geometry.getModel().modelLocation.toString()) && geometryName.equals(this.model.geometry.getDescription().getIdentifier());
    }

    public static int read4Bytes(InputStream stream) throws IOException {
        int result = 0;
        result += stream.read();
        result += stream.read() << 8;
        result += stream.read() << 16;
        return result += stream.read() << 24;
    }

    public static void write4Bytes(int in, OutputStream stream) throws IOException {
        stream.write(in & 0xFF);
        stream.write(in >> 8 & 0xFF);
        stream.write(in >> 16 & 0xFF);
        stream.write(in >>> 24);
    }
}

