/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.anim_instance;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import kasuga.lib.core.annos.Beta;
import kasuga.lib.core.client.model.AnimModelLoader;
import kasuga.lib.core.client.model.anim_instance.AnimateTicker;
import kasuga.lib.core.client.model.anim_instance.AnimateTickerManager;
import kasuga.lib.core.client.model.anim_instance.AnimationInstance;
import kasuga.lib.core.client.model.anim_instance.Ticker;
import kasuga.lib.core.client.model.anim_json.Animation;
import kasuga.lib.core.client.model.anim_json.AnimationFile;
import kasuga.lib.core.client.model.anim_model.AnimModel;
import kasuga.lib.core.util.LazyRecomputable;
import kasuga.lib.core.util.data_type.Pair;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@Beta
public class MultiAnimateTicker
implements Ticker {
    private final HashMap<Pair<ResourceLocation, String>, AnimateTicker> tickers = new HashMap();
    public final AnimateTicker.TickerType type;
    private final AnimModel model;

    public MultiAnimateTicker(float playSpeed, AnimateTicker.TickerType type, AnimationInstance ... instance) {
        this.model = instance.length > 0 ? instance[0].model : null;
        for (AnimationInstance a : instance) {
            if (a == null) continue;
            if (!a.model.equals(this.model)) {
                this.tickers.clear();
                break;
            }
            this.tickers.put(Pair.of(a.animation.file.location, a.animation.name), new AnimateTicker(a, this.getType(), playSpeed));
        }
        this.type = type;
        this.submit();
    }

    @Override
    public void submit() {
        AnimateTickerManager.INSTANCE.putTickerIn(this);
    }

    @Override
    public void unload() {
        AnimateTickerManager.INSTANCE.removeTicker(this);
    }

    @Override
    public AnimateTicker.TickerType getType() {
        return this.type;
    }

    public void setStarterTick(ResourceLocation file, String name, int tick) {
        AnimateTicker ticker = this.getTicker(file, name);
        if (ticker == null) {
            return;
        }
        ticker.setStarterTick(tick);
    }

    public void setPlaySpeed(ResourceLocation file, String name, float speed) {
        AnimateTicker ticker = this.getTicker(file, name);
        if (ticker == null) {
            return;
        }
        ticker.setPlaySpeed(speed);
    }

    public int getEndTick(ResourceLocation file, String name) {
        AnimateTicker ticker = this.getTicker(file, name);
        if (ticker == null) {
            return -1;
        }
        return ticker.getTick();
    }

    public void start(ResourceLocation file, String name) {
        AnimateTicker ticker = this.getTicker(file, name);
        if (ticker == null) {
            return;
        }
        ticker.start();
    }

    public void startAll() {
        this.tickers.forEach((a, b) -> b.start());
    }

    public void stop(ResourceLocation file, String name) {
        AnimateTicker ticker = this.getTicker(file, name);
        if (ticker == null) {
            return;
        }
        ticker.stop();
    }

    public void stopAll() {
        this.tickers.forEach((a, b) -> b.stop());
    }

    public void pause(ResourceLocation file, String name) {
        AnimateTicker ticker = this.getTicker(file, name);
        if (ticker == null) {
            return;
        }
        ticker.pause();
    }

    public void pauseAll() {
        this.tickers.forEach((a, b) -> b.pause());
    }

    public boolean isPaused(ResourceLocation file, String name) {
        AnimateTicker ticker = this.getTicker(file, name);
        return ticker != null && ticker.isPaused();
    }

    public float getPlaySpeed(ResourceLocation file, String name) {
        AnimateTicker ticker = this.getTicker(file, name);
        if (ticker == null) {
            return -1.0f;
        }
        return ticker.getPlaySpeed();
    }

    public boolean isMoving(ResourceLocation file, String name) {
        AnimateTicker ticker = this.getTicker(file, name);
        return ticker != null && ticker.isMoving();
    }

    public void setMoving(ResourceLocation file, String name, boolean moving) {
        AnimateTicker ticker = this.getTicker(file, name);
        if (ticker == null) {
            return;
        }
        ticker.setMoving(moving);
    }

    public void tickAndRender(PoseStack pose, MultiBufferSource source, int light, int overlay, float partial) {
        this.mergeAnimation(partial);
        this.model.render(pose, source, light, overlay);
    }

    public void mergeAnimation(float partial) {
        HashMap result = Maps.newHashMap();
        this.tickers.forEach((name, ticker) -> ticker.animation.mergeAnimation(result, ticker.tickToSec(partial)));
        this.model.applyAnimation(result);
    }

    @Override
    public void tick(int tick) {
        this.tickers.forEach((name, ticker) -> ticker.tick(tick));
    }

    public AnimateTicker getTicker(ResourceLocation file, String name) {
        return this.tickers.getOrDefault(Pair.of(file, name), null);
    }

    public static LazyRecomputable<MultiAnimateTicker> getTickerInstance(ResourceLocation modelLoc, AnimateTicker.TickerType ticker, int frameRate, float playSpeed, Pair<ResourceLocation, String> ... anims) {
        return new LazyRecomputable<MultiAnimateTicker>(() -> {
            AnimationInstance[] instances = new AnimationInstance[anims.length];
            int counter = 0;
            AnimModel model = AnimModelLoader.INSTANCE.getModel(modelLoc);
            if (model == null) {
                return null;
            }
            if (!model.isValidForRender()) {
                model.init();
            }
            for (Pair a : anims) {
                AnimationFile file = AnimationFile.fromFile((ResourceLocation)a.getFirst()).get();
                if (file == null) {
                    return null;
                }
                Animation anim = file.getAnimation((String)a.getSecond());
                if (anim == null) {
                    return null;
                }
                instances[counter] = anim.getInstance(model, frameRate);
                ++counter;
            }
            return new MultiAnimateTicker(playSpeed, ticker, instances);
        });
    }
}

