/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.anim_json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.model.anim_instance.AnimCacheManager;
import kasuga.lib.core.client.model.anim_instance.AnimationInstance;
import kasuga.lib.core.client.model.anim_json.AnimationFile;
import kasuga.lib.core.client.model.anim_json.KeyFrame;
import kasuga.lib.core.client.model.anim_json.LoopMode;
import kasuga.lib.core.client.model.anim_model.AnimModel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Animation {
    public final String name;
    public final AnimationFile file;
    private final HashMap<String, KeyFrame> frames;
    public final float animationLength;
    private final LoopMode loop;

    public Animation(String name, JsonObject json, AnimationFile file) {
        JsonElement element;
        this.file = file;
        this.frames = new HashMap();
        this.name = name;
        this.loop = !json.has("loop") ? LoopMode.NONE : ((element = json.get("loop")).getAsString().equals("hold_on_last_frame") ? LoopMode.HOLD_ON_LAST_FRAME : (element.getAsString().equals("true") ? LoopMode.LOOP : LoopMode.NONE));
        float f = this.animationLength = json.has("animation_length") ? json.get("animation_length").getAsFloat() : 0.0f;
        if (json.has("bones")) {
            this.deserializeKeyframes(json.getAsJsonObject("bones"));
        }
    }

    private void deserializeKeyframes(JsonObject json) {
        json.entrySet().forEach(entry -> {
            String boneName = (String)entry.getKey();
            Object patt1825$temp = entry.getValue();
            if (!(patt1825$temp instanceof JsonObject)) {
                return;
            }
            JsonObject object = (JsonObject)patt1825$temp;
            KeyFrame frame = new KeyFrame(boneName, object);
            this.frames.put(boneName, frame);
        });
    }

    public KeyFrame getFrame(String name) {
        return this.frames.getOrDefault(name, null);
    }

    public boolean hasFrame(String name) {
        return this.frames.containsKey(name);
    }

    public HashMap<String, KeyFrame> getFrames() {
        return this.frames;
    }

    public LoopMode getLoop() {
        return this.loop;
    }

    public float getAnimationLength() {
        return this.animationLength;
    }

    public String getName() {
        return this.name;
    }

    public AnimationInstance getInstance(AnimModel model, int frameRate) {
        String pureFileName = AnimCacheManager.getPureFileName(this, model, frameRate);
        if (!AnimCacheManager.systemEnabled()) {
            return new AnimationInstance(this, model, frameRate);
        }
        if (AnimCacheManager.INSTANCE.hasCache(pureFileName)) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(AnimCacheManager.INSTANCE.getCache(pureFileName));
                AnimationInstance fromCache = new AnimationInstance(model, this, bais);
                return fromCache;
            }
            catch (IOException e) {
                KasugaLib.MAIN_LOGGER.error("InValid file: " + pureFileName, (Throwable)e);
                return this.buildNewInstance(model, frameRate);
            }
        }
        return this.buildNewInstance(model, frameRate);
    }

    private AnimationInstance buildNewInstance(AnimModel model, int frameRate) {
        AnimationInstance instance = new AnimationInstance(this, model, frameRate);
        try {
            if (AnimCacheManager.systemEnabled()) {
                AnimCacheManager.INSTANCE.save(instance);
            }
        }
        catch (IOException e) {
            KasugaLib.MAIN_LOGGER.error("Failed to save animation cache file: " + AnimCacheManager.getPureFileName(instance), (Throwable)e);
        }
        return instance;
    }
}

