/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.anim_json;

import com.mojang.math.Vector3f;
import kasuga.lib.core.client.render.texture.Vec2f;

public class CatmullRomUtils {
    public static final float DEFAULT_TAU = 0.5f;

    public static Vector3f[] first3PointsToCRSPoints(Vector3f p0, Vector3f p1, Vector3f p2) {
        Vector3f p3 = p2.m_122281_();
        p3.m_122261_(2.0f);
        p3.m_122267_(p1);
        return CatmullRomUtils.genDefaultCRSPoints(p0, p1, p2, p3);
    }

    public static Vector3f[] last3PointsToCRSPoints(Vector3f p1, Vector3f p2, Vector3f p3) {
        Vector3f p0 = p1.m_122281_();
        p0.m_122261_(2.0f);
        p0.m_122267_(p2);
        return CatmullRomUtils.genDefaultCRSPoints(p0, p1, p2, p3);
    }

    public static Vector3f[] genDefaultCRSPoints(Vector3f p0, Vector3f p1, Vector3f p2, Vector3f p3) {
        return CatmullRomUtils.genCRSPoints(0.5f, p0, p1, p2, p3);
    }

    public static Vector3f[] genCRSPoints(float tau, Vector3f p0, Vector3f p1, Vector3f p2, Vector3f p3) {
        Vector3f c0 = p1.m_122281_();
        Vector3f c1 = p0.m_122281_();
        c1.m_122261_(-tau);
        Vector3f m1 = p2.m_122281_();
        m1.m_122261_(tau);
        c1.m_122253_(m1);
        Vector3f c2 = p0.m_122281_();
        c2.m_122261_(2.0f * tau);
        Vector3f m2 = p1.m_122281_();
        m2.m_122261_(tau - 3.0f);
        c2.m_122253_(m2);
        Vector3f m3 = p2.m_122281_();
        m3.m_122261_(3.0f - 2.0f * tau);
        c2.m_122253_(m3);
        Vector3f m4 = p3.m_122281_();
        m4.m_122261_(-tau);
        c2.m_122253_(m4);
        Vector3f c3 = p0.m_122281_();
        c3.m_122261_(-tau);
        Vector3f m5 = p1.m_122281_();
        m5.m_122261_(2.0f - tau);
        c3.m_122253_(m5);
        Vector3f m6 = p2.m_122281_();
        m6.m_122261_(tau - 2.0f);
        c3.m_122253_(m6);
        Vector3f m7 = p3.m_122281_();
        m7.m_122261_(tau);
        c3.m_122253_(m7);
        return new Vector3f[]{c0, c1, c2, c3};
    }

    public static Vector3f applyCRS(Vector3f[] points, float u) {
        Vector3f result = points[0].m_122281_();
        Vector3f v1 = points[1].m_122281_();
        v1.m_122261_(u);
        result.m_122253_(v1);
        Vector3f v2 = points[2].m_122281_();
        v2.m_122261_(u * u);
        result.m_122253_(v2);
        Vector3f v3 = points[3].m_122281_();
        v3.m_122261_(u * u * u);
        result.m_122253_(v3);
        return result;
    }

    public static Vec2f[] first3PointsToCRSPoints(Vec2f p0, Vec2f p1, Vec2f p2) {
        return CatmullRomUtils.genDefaultCRSPoints(p0, p1, p2, p2.scale(2.0f).subtract(p1));
    }

    public static Vec2f[] last3PointsToCRSPoints(Vec2f p1, Vec2f p2, Vec2f p3) {
        return CatmullRomUtils.genDefaultCRSPoints(p1.scale(2.0f).subtract(p2), p1, p2, p3);
    }

    public static Vec2f[] genDefaultCRSPoints(Vec2f p0, Vec2f p1, Vec2f p2, Vec2f p3) {
        return CatmullRomUtils.genCRSPoints(0.5f, p0, p1, p2, p3);
    }

    public static Vec2f[] genCRSPoints(float tau, Vec2f p0, Vec2f p1, Vec2f p2, Vec2f p3) {
        Vec2f c0 = p0;
        Vec2f c1 = p0.scale(-tau).add(p2.scale(tau));
        Vec2f c2 = p0.scale(2.0f * tau).add(p1.scale(tau - 3.0f)).add(p2.scale(3.0f - 2.0f * tau)).add(p3.scale(-tau));
        Vec2f c3 = p0.scale(-tau).add(p1.scale(2.0f - tau)).add(p2.scale(tau - 2.0f)).add(p3.scale(tau));
        return new Vec2f[]{c0, c1, c2, c3};
    }

    public static Vec2f applyCRS(Vec2f[] points, float u) {
        return points[0].add(points[1].scale(u)).add(points[2].scale(u * u)).add(points[3].scale(u * u * u));
    }
}

