/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.anim_model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kasuga.lib.core.client.model.BedrockRenderable;
import kasuga.lib.core.client.model.anim_model.AnimCube;
import kasuga.lib.core.client.model.anim_model.AnimModel;
import kasuga.lib.core.client.model.anim_model.Animable;
import kasuga.lib.core.client.model.model_json.Bone;
import kasuga.lib.core.client.model.model_json.Cube;
import kasuga.lib.core.client.model.model_json.Locator;
import kasuga.lib.core.client.render.SimpleColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnimBone
implements BedrockRenderable,
Animable {
    public final Bone bone;
    private final Vector3f pivot;
    private final Vector3f rotation;
    private final Map<String, BedrockRenderable> children;
    private final List<BedrockRenderable> cubes;
    private final HashMap<String, Locator> locators;
    public final AnimModel model;
    private AnimBone parent;
    private Vector3f offset;
    private Vector3f animRot;
    private Vector3f scale;

    public AnimBone(Bone bone, AnimModel model) {
        this.bone = bone;
        this.pivot = bone.pivot.m_122281_();
        this.rotation = bone.rotation.m_122281_();
        this.pivot.m_122261_(0.0625f);
        this.children = Maps.newHashMap();
        this.model = model;
        this.cubes = Lists.newArrayList();
        this.locators = new HashMap();
        this.collectCubes();
        this.initAnim();
    }

    protected AnimBone(Bone bone, AnimModel model, List<BedrockRenderable> cubes, HashMap<String, Locator> locators) {
        this.bone = bone;
        this.children = new HashMap<String, BedrockRenderable>();
        this.model = model;
        this.cubes = new ArrayList<BedrockRenderable>(cubes.size());
        cubes.forEach(c -> this.cubes.add(((AnimCube)c).copy(model, this)));
        this.locators = new HashMap();
        locators.forEach((name, locator) -> this.locators.put((String)name, locator.copy()));
        this.pivot = bone.pivot.m_122281_();
        this.rotation = bone.rotation.m_122281_();
        this.initAnim();
    }

    private void collectLocators() {
        HashMap<String, Locator> locators = this.bone.getLocators();
        Vector3f parentPivot = this.parent == null ? Vector3f.f_176763_.m_122281_() : this.parent.getPivot().m_122281_();
        locators.forEach((name, loc) -> this.locators.put((String)name, new Locator(this.vonvertPivot(loc.position, parentPivot), loc.rotation)));
    }

    private void collectCubes() {
        ArrayList<Cube> cubes = this.bone.getCubes();
        for (Cube cube : cubes) {
            AnimCube ac = new AnimCube(cube, this.model, this);
            this.cubes.add(ac);
        }
    }

    public void addThisToParent() {
        BedrockRenderable parent = this.model.getChild(this.bone.parent);
        if (!(parent instanceof AnimBone)) {
            return;
        }
        AnimBone parentBone = (AnimBone)parent;
        Map<String, BedrockRenderable> map = parentBone.getChildrens();
        map.put(this.bone.name, this);
        this.parent = (AnimBone)this.model.getChild(this.bone.parent);
        this.collectLocators();
    }

    @Override
    public Map<String, BedrockRenderable> getChildrens() {
        return this.children;
    }

    @Override
    public BedrockRenderable getChild(String name) {
        return this.children.getOrDefault(name, null);
    }

    public BedrockRenderable getChild(int index) {
        return this.children.getOrDefault(String.valueOf(index), null);
    }

    public Vector3f getPivot() {
        return this.pivot.m_122281_();
    }

    public void resetAnimation() {
        this.initAnim();
    }

    public void initAnim() {
        this.offset = Vector3f.f_176763_.m_122281_();
        this.animRot = Vector3f.f_176763_.m_122281_();
        this.scale = new Vector3f(1.0f, 1.0f, 1.0f);
    }

    public Vector3f getRealPosition() {
        Vector3f result = this.pivot.m_122281_();
        result.m_122253_(this.offset);
        return result;
    }

    @Override
    public void setOffset(Vector3f offset) {
        this.offset = offset;
    }

    public Vector3f getRealRotation() {
        Vector3f result = this.rotation.m_122281_();
        result.m_122253_(this.animRot);
        return result;
    }

    @Override
    public void setAnimRot(Vector3f animRot) {
        this.animRot = animRot;
    }

    @Override
    public void setScale(Vector3f scale) {
        this.scale = scale;
    }

    @Override
    public void applyTranslationAndRotation(PoseStack pose) {
        Vector3f translation = this.getRealPosition();
        Vector3f parentTrans = this.parent != null ? this.parent.getPivot().m_122281_() : Vector3f.f_176763_.m_122281_();
        Vector3f t = this.vonvertPivot(translation, parentTrans);
        pose.m_85837_((double)t.m_122239_(), (double)t.m_122260_(), (double)t.m_122269_());
        Vector3f rotation = this.getRealRotation();
        if (!rotation.equals((Object)Vector3f.f_176763_)) {
            pose.m_85845_(Vector3f.f_122227_.m_122240_(rotation.m_122269_()));
            pose.m_85845_(Vector3f.f_122224_.m_122240_(rotation.m_122260_()));
            pose.m_85845_(Vector3f.f_122222_.m_122240_(rotation.m_122239_()));
        }
        if (this.scale.equals((Object)Cube.BASE_SCALE)) {
            return;
        }
        pose.m_85841_(this.scale.m_122239_(), this.scale.m_122260_(), this.scale.m_122269_());
    }

    @Override
    public void render(PoseStack pose, VertexConsumer consumer, SimpleColor color, int light, int overlay) {
        pose.m_85836_();
        this.applyTranslationAndRotation(pose);
        this.cubes.forEach(c -> c.render(pose, consumer, color, light, overlay));
        this.children.forEach((c, d) -> d.render(pose, consumer, color, light, overlay));
        pose.m_85849_();
    }

    public void recursionClearAnim() {
        this.initAnim();
        this.children.forEach((name, b) -> {
            if (!(b instanceof AnimBone)) {
                return;
            }
            AnimBone animBone = (AnimBone)b;
            animBone.recursionClearAnim();
        });
    }

    public AnimBone copy(Bone bone, AnimModel model) {
        return new AnimBone(bone, model, this.cubes, this.locators);
    }
}

