/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.model_json;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.model.model_json.Geometry;
import kasuga.lib.core.util.Resources;
import lombok.Generated;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.SimpleUnbakedGeometry;

@OnlyIn(value=Dist.CLIENT)
public class BedrockModel
extends SimpleUnbakedGeometry<BedrockModel> {
    public final ResourceLocation modelLocation;
    private final List<Material> materials;
    private Material textureMaterial;
    private final ArrayList<Geometry> geometries;
    private final boolean flipV;
    private String formatVersion;
    private boolean legacy;

    public BedrockModel(ResourceLocation modelLocation, boolean flipV) {
        this.flipV = flipV;
        this.modelLocation = modelLocation;
        this.geometries = Lists.newArrayList();
        this.materials = Lists.newArrayList();
        this.legacy = false;
        this.parse();
    }

    public BedrockModel(ResourceLocation modelLocation, boolean flipV, Material textureMaterial, List<Material> materials) {
        this(modelLocation, flipV, textureMaterial, materials.toArray(new Material[0]));
    }

    public BedrockModel(ResourceLocation modelLocation, boolean flipV, Material textureMaterial, Material ... material) {
        this.flipV = flipV;
        this.modelLocation = modelLocation;
        this.textureMaterial = textureMaterial;
        this.geometries = new ArrayList();
        this.legacy = false;
        this.materials = Lists.newArrayList();
        this.parse();
        this.materials.addAll(List.of(material));
    }

    public void parse() {
        JsonArray geos;
        JsonObject model = this.readModel();
        if (model == null) {
            KasugaLib.MAIN_LOGGER.warn("Unable to open animated model: " + this.modelLocation.toString());
            return;
        }
        this.formatVersion = model.get("format_version").getAsString();
        if (model.has("minecraft:geometry")) {
            geos = model.getAsJsonArray("minecraft:geometry");
            this.legacy = false;
        } else {
            geos = new JsonArray();
            if (model.has("geometry.model")) {
                geos.add(model.get("geometry.model"));
            }
            this.legacy = true;
        }
        for (JsonElement element : geos) {
            JsonObject geometryJson = element.getAsJsonObject();
            Geometry geometry = new Geometry(geometryJson, this);
            this.geometries.add(geometry);
        }
    }

    public Set<String> getConfigurableComponentNames() {
        HashSet<String> result = new HashSet<String>();
        this.geometries.forEach(bone -> result.add(bone.getDescription().getIdentifier()));
        return result;
    }

    public JsonObject readModel() {
        JsonObject model;
        try {
            Resource resource = Resources.getResource(this.modelLocation);
            model = JsonParser.parseReader((Reader)resource.m_215508_()).getAsJsonObject();
        }
        catch (IOException e) {
            KasugaLib.MAIN_LOGGER.error("Failed to load animated model: " + this.modelLocation.toString(), (Throwable)e);
            return null;
        }
        return model;
    }

    public String getFormatVersion() {
        return this.formatVersion;
    }

    public List<Material> getMaterials() {
        return this.materials;
    }

    public boolean isFlipV() {
        return this.flipV;
    }

    public List<Geometry> getGeometries() {
        return this.geometries;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    protected void addQuads(IGeometryBakingContext owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
        this.geometries.forEach(geometry -> geometry.addQuads(owner, modelBuilder, bakery, spriteGetter, modelTransform, modelLocation));
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<Material> materials = new HashSet<Material>(this.materials);
        return materials;
    }

    @Generated
    public Material getTextureMaterial() {
        return this.textureMaterial;
    }

    @Generated
    public void setTextureMaterial(Material textureMaterial) {
        this.textureMaterial = textureMaterial;
    }
}

