/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.model_json;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kasuga.lib.core.client.model.Rotationable;
import kasuga.lib.core.client.model.model_json.Bone;
import kasuga.lib.core.client.model.model_json.BoxLayerProcessor;
import kasuga.lib.core.client.model.model_json.ForAnimModel;
import kasuga.lib.core.client.model.model_json.Geometry;
import kasuga.lib.core.client.model.model_json.GeometryDescription;
import kasuga.lib.core.client.model.model_json.Quad;
import kasuga.lib.core.client.model.model_json.UnbakedUV;
import kasuga.lib.core.client.model.model_json.Vertex;
import kasuga.lib.core.client.render.texture.Vec2f;
import lombok.Generated;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;

@OnlyIn(value=Dist.CLIENT)
public class Cube
implements Rotationable {
    private final Vector3f origin;
    private final Vector3f size;
    private final Vector3f pivot;
    private final Vector3f rotation;
    private final ArrayList<UnbakedUV> uvs;
    public final Geometry model;
    public final Bone bone;
    public final boolean mirror;
    public final boolean visible;
    public final boolean emissive;
    private final float inflate;
    public static final Vector3f BASE_OFFSET = new Vector3f(0.5f, 0.0f, 0.5f);
    public static final Vector3f BASE_SCALE = new Vector3f(1.0f, 1.0f, 1.0f);

    public Cube(JsonObject object, Geometry model, Bone bone) {
        this.bone = bone;
        this.model = model;
        this.uvs = new ArrayList();
        JsonArray orgJson = object.getAsJsonArray("origin");
        this.origin = new Vector3f(orgJson.get(0).getAsFloat() / 16.0f, orgJson.get(1).getAsFloat() / 16.0f, orgJson.get(2).getAsFloat() / 16.0f);
        JsonArray sizeJson = object.getAsJsonArray("size");
        this.size = new Vector3f(sizeJson.get(0).getAsFloat() / 16.0f, sizeJson.get(1).getAsFloat() / 16.0f, sizeJson.get(2).getAsFloat() / 16.0f);
        this.origin.setX(-1.0f * (this.origin.m_122239_() + this.size.m_122239_()));
        if (object.has("pivot")) {
            JsonArray pivotJson = object.getAsJsonArray("pivot");
            this.pivot = new Vector3f(-pivotJson.get(0).getAsFloat(), pivotJson.get(1).getAsFloat(), pivotJson.get(2).getAsFloat());
        } else {
            this.pivot = new Vector3f();
        }
        if (object.has("rotation")) {
            JsonArray rotationJson = object.getAsJsonArray("rotation");
            this.rotation = new Vector3f(rotationJson.get(0).getAsFloat(), rotationJson.get(1).getAsFloat(), rotationJson.get(2).getAsFloat());
        } else {
            this.rotation = new Vector3f();
        }
        this.mirror = object.has("mirror") && object.get("mirror").getAsBoolean();
        this.visible = !object.has("visible") || object.get("visible").getAsBoolean();
        this.emissive = object.has("emissive") && object.get("emissive").getAsBoolean();
        this.inflate = object.has("inflate") ? object.get("inflate").getAsFloat() / 16.0f : 0.0f;
        boolean flipV = bone.isFlipV();
        if (object.get("uv").isJsonArray()) {
            JsonArray uv = object.getAsJsonArray("uv");
            Vec2f uvOffset = new Vec2f(uv.get(0).getAsFloat(), uv.get(1).getAsFloat()).scale(1.0f / this.getDescription().getTextureWidth(), 1.0f / this.getDescription().getTextureHeight());
            BoxLayerProcessor processor = new BoxLayerProcessor(this, uvOffset, flipV);
            for (Direction value : Direction.values()) {
                this.uvs.add(processor.getUV(value));
            }
            return;
        }
        for (Map.Entry entry : object.get("uv").getAsJsonObject().entrySet()) {
            UnbakedUV uv = new UnbakedUV(Direction.m_122402_((String)((String)entry.getKey())), ((JsonElement)entry.getValue()).getAsJsonObject(), model.getDescription().getTextureWidth(), model.getDescription().getTextureHeight(), this.mirror, flipV, this.visible, this.emissive);
            this.uvs.add(uv);
        }
    }

    public GeometryDescription getDescription() {
        return this.model.getDescription();
    }

    public List<Quad> getQuads() {
        ArrayList<Quad> result = new ArrayList<Quad>(6);
        for (UnbakedUV uv : this.uvs) {
            Quad quad = new Quad(this, uv, this.model);
            if (quad.skip) continue;
            result.add(quad);
        }
        return result;
    }

    @Override
    public boolean hasParent() {
        return true;
    }

    @Override
    public Rotationable getParent() {
        return this.bone;
    }

    public void addQuads(IGeometryBakingContext owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
        TextureAtlasSprite sprite = spriteGetter.apply(this.model.getModel().getTextureMaterial());
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        float width = u1 - u0;
        float height = v1 - v0;
        Rotationable.RotationContext context = this.startCompileRotate();
        Vector3f position = context.position();
        position.m_122261_(0.0625f);
        Vector3f pivot = this.getPivot().m_122281_();
        pivot.m_122261_(0.0625f);
        List<Quad> quads = this.getQuads();
        Vector3f universalOffset = modelTransform.m_6189_().m_175940_().m_122281_();
        Vector3f universalScale = modelTransform.m_6189_().m_175941_();
        universalOffset.m_122253_(BASE_OFFSET);
        quads = this.rotQuads(quads, pivot, position, context.quaternions());
        if (!modelTransform.m_6189_().m_121105_().equals((Object)Quaternion.f_80118_)) {
            quads = this.rotQuads(quads, Vector3f.f_176763_, modelTransform.m_6189_().m_121105_());
        }
        quads = this.translateQuads(quads, universalOffset);
        if (!universalScale.equals((Object)BASE_SCALE)) {
            quads = this.scaleQuads(quads, Vector3f.f_176763_, universalScale);
        }
        HashMap<Direction, int[]> aint = this.fillVertices(quads, u0, v0, width, height);
        aint.forEach((direction, ints) -> {
            BakedQuad quad = new BakedQuad(ints, 0, direction, sprite, true);
            modelBuilder.addCulledFace(direction, quad);
        });
    }

    public List<Quad> translateQuads(List<Quad> quads, Vector3f offset) {
        return this.controlQuads(quads, vertex -> vertex.applyTranslation(offset));
    }

    public List<Quad> rotQuads(List<Quad> input, Vector3f pivot, Vector3f position, List<Quaternion> quaternions) {
        Vector3f p = pivot.m_122281_();
        return this.controlQuads(input, vertex -> vertex.applyRotation(p, position, quaternions));
    }

    public List<Quad> rotQuads(List<Quad> input, Vector3f pivot, Quaternion quaternion) {
        Vector3f p = pivot.m_122281_();
        return this.controlQuads(input, vertex -> vertex.applyRotation(p, quaternion));
    }

    public List<Quad> scaleQuads(List<Quad> input, Vector3f pivot, Vector3f scale) {
        Vector3f s = scale.m_122281_();
        return this.controlQuads(input, vertex -> vertex.applyScale(pivot, s));
    }

    public List<Quad> controlQuads(List<Quad> input, Function<Vertex, Vertex> function) {
        ArrayList<Quad> result = new ArrayList<Quad>(input.size());
        for (Quad q : input) {
            Vertex[] vertices = new Vertex[4];
            for (int i = 0; i < 4; ++i) {
                Vertex vertex = q.vertices[i];
                vertices[i] = function.apply(vertex);
            }
            result.add(new Quad(vertices, q.direction, q.model, q.skip));
        }
        return result;
    }

    public HashMap<Direction, int[]> fillVertices(List<Quad> quads, float u0, float v0, float uWidth, float vHeight) {
        HashMap result = Maps.newHashMap();
        for (Quad quad : quads) {
            int[] v = new int[32];
            quad.fillVertex(v, u0, v0, uWidth, vHeight);
            result.put(quad.direction, v);
        }
        return result;
    }

    @ForAnimModel
    public List<BakedQuad> getBaked(TextureAtlasSprite sprite, Vector3f offset) {
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        float width = u1 - u0;
        float height = v1 - v0;
        List<Quad> quads = this.getQuads();
        quads.forEach(quad -> quad.offsetWithoutCopy(offset));
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(quads.size());
        HashMap<Direction, int[]> aint = this.fillVertices(quads, u0, v0, width, height);
        aint.forEach((direction, ints) -> {
            BakedQuad baked = new BakedQuad(ints, 0, direction, sprite, true);
            result.add(baked);
        });
        return result;
    }

    @Generated
    public Vector3f getOrigin() {
        return this.origin;
    }

    @Generated
    public Vector3f getSize() {
        return this.size;
    }

    @Override
    @Generated
    public Vector3f getPivot() {
        return this.pivot;
    }

    @Override
    @Generated
    public Vector3f getRotation() {
        return this.rotation;
    }

    @Generated
    public float getInflate() {
        return this.inflate;
    }
}

