/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render.curve;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kasuga.lib.core.client.model.anim_json.CatmullRomUtils;
import kasuga.lib.core.client.render.curve.CurveTemplate;
import kasuga.lib.core.client.render.texture.Vec2f;
import kasuga.lib.core.util.data_type.Pair;

public class CatmullromCurveTemplate
implements CurveTemplate {
    private final List<Pair<Vec2f, Vec2f[]>> anchors;
    private final List<Vec2f> points;
    private float left;
    private float right;
    private float step;

    public CatmullromCurveTemplate(float left, float right, float step, List<Vec2f> anchors) {
        this.anchors = new ArrayList<Pair<Vec2f, Vec2f[]>>(anchors.isEmpty() ? 0 : anchors.size() - 1);
        this.points = Lists.newArrayList();
        this.left = left;
        this.right = right;
        this.step = step;
        boolean flag = this.compileAnchors(anchors, false);
        if (flag) {
            this.compileCurve();
        } else {
            this.compileLine();
        }
    }

    public boolean compileAnchors(List<Vec2f> anchors, boolean shouldClear) {
        if (shouldClear) {
            this.anchors.clear();
        }
        if (anchors.size() < 3) {
            return false;
        }
        for (int i = 0; i < anchors.size() - 1; ++i) {
            Vec2f[] controllers;
            Vec2f p1 = anchors.get(i);
            Vec2f p2 = anchors.get(i + 1);
            if (i == 0) {
                Vec2f p3 = anchors.get(i + 2);
                controllers = CatmullRomUtils.last3PointsToCRSPoints(p1, p2, p3);
            } else if (i == anchors.size() - 2) {
                p0 = anchors.get(i - 1);
                controllers = CatmullRomUtils.first3PointsToCRSPoints(p0, p1, p2);
            } else {
                p0 = anchors.get(i - 1);
                Vec2f p3 = anchors.get(i + 2);
                controllers = CatmullRomUtils.genDefaultCRSPoints(p0, p1, p2, p3);
            }
            this.anchors.add(Pair.of(p1, controllers));
        }
        return true;
    }

    @Override
    public List<Vec2f> getPointList() {
        return this.points;
    }

    public void compileCurve() {
        this.points.clear();
        float length = this.right - this.left;
        if (length * this.step < 0.0f) {
            return;
        }
        for (int i = 0; i < this.anchors.size() - 1; ++i) {
            Vec2f p0 = this.anchors.get(i).getFirst();
            Vec2f p1 = this.anchors.get(i + 1).getFirst();
            float l = Math.min(this.left, this.right);
            float r = Math.max(this.left, this.right);
            if (p0.x() < l && p1.x() < l || p0.x() > r && p1.x() > r) continue;
            float pl = Math.min(p0.x(), p1.x());
            float f = Math.max(p0.x(), p1.x());
        }
    }

    public void compileLine() {
    }

    @Override
    public Pair<Float, Float> getRange() {
        return Pair.of(Float.valueOf(this.left), Float.valueOf(this.right));
    }

    @Override
    public void setLeft(float left) {
        this.left = left;
    }

    @Override
    public void setRight(float right) {
        this.right = right;
    }

    @Override
    public float getStep() {
        return this.step;
    }
}

