/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render.curve;

import com.google.common.collect.Lists;
import java.util.List;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.render.curve.CurveTemplate;
import kasuga.lib.core.client.render.texture.Vec2f;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.vendor_modules.interpreter.Code;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Formula;
import org.jetbrains.annotations.NotNull;

public class FunctionCurveTemplate
implements CurveTemplate {
    private final Namespace namespace = new Namespace(Code.root());
    private Formula formula;
    @NotNull
    private String independentVar;
    private float left;
    private float right;
    private float step;
    private final List<Vec2f> cache;

    public FunctionCurveTemplate(String function, float left, float right, float step) {
        this.formula = this.namespace.decodeFormula(function);
        this.left = left;
        this.right = right;
        this.step = step;
        this.cache = Lists.newArrayList();
        this.independentVar = "x";
    }

    public void setIndependentVar(@NotNull String independentVar) {
        this.independentVar = independentVar;
    }

    @Override
    public void setLeft(float left) {
        this.left = left;
    }

    @Override
    public void setRight(float right) {
        this.right = right;
    }

    public void setStep(float step) {
        this.step = step;
    }

    public void setFunction(String formula) {
        this.formula = this.namespace.decodeFormula(formula);
    }

    @Override
    public List<Vec2f> getPointList() {
        return this.cache;
    }

    public void compile() {
        this.cache.clear();
        float length = this.right - this.left;
        if (length * this.step < 0.0f) {
            KasugaLib.MAIN_LOGGER.error("Predictions are not likely to be fulfilled.");
            return;
        }
        boolean flag = length < 0.0f;
        float i = this.left;
        while (flag ? i > this.right : i < this.right) {
            this.namespace.assign(this.independentVar, i);
            float result = this.formula.getResult();
            this.getPointList().add(new Vec2f(i, result));
            i += this.step;
        }
    }

    @Override
    public float getStep() {
        return this.step;
    }

    @Override
    public Pair<Float, Float> getRange() {
        return Pair.of(Float.valueOf(this.left), Float.valueOf(this.right));
    }
}

